/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz;

import com.sangupta.nutz.MarkupUtils;
import com.sangupta.nutz.ProcessingOptions;
import com.sangupta.nutz.ast.LineType;

public class TextLine {
    String text;
    int leadingPosition = -1;
    int leadingSpaces = -1;
    int length = -1;
    LineType lineType = null;
    char terminator = '\u0000';
    boolean horizontalRule = false;
    boolean trimEmpty = false;
    boolean isEmpty = false;
    boolean isNull = false;
    private ProcessingOptions options;

    public TextLine(String text, ProcessingOptions options) {
        this.options = options;
        this.text = text;
        this.initialize();
    }

    private void initialize() {
        if (this.text == null) {
            this.isEmpty = true;
            this.isNull = true;
            this.length = 0;
            return;
        }
        this.isEmpty = this.text.isEmpty();
        this.length = this.text.length();
        this.trimEmpty = this.text.trim().isEmpty();
        int[] spaceTokens = MarkupUtils.findLeadingSpaces(this.text);
        this.leadingPosition = spaceTokens[0];
        this.leadingSpaces = spaceTokens[1];
        this.lineType = this.decipherLineType();
    }

    private LineType decipherLineType() {
        if (this.trimEmpty) {
            return LineType.Empty;
        }
        if (this.leadingSpaces >= 4) {
            return LineType.CodeBlock;
        }
        if (this.text.startsWith("<!--", this.leadingPosition)) {
            return LineType.HtmlComment;
        }
        if (this.text.startsWith("#", this.leadingPosition)) {
            return LineType.Heading;
        }
        if (this.options.enableGithubFencedCodeBlocks && this.text.startsWith("```", this.leadingPosition)) {
            this.terminator = (char)96;
            return LineType.FencedCodeBlock;
        }
        if (this.options.enablePhpFencedCodeBlocks && this.text.startsWith("~~~", this.leadingPosition)) {
            this.terminator = (char)126;
            return LineType.FencedCodeBlock;
        }
        if (this.text.startsWith("===", this.leadingPosition)) {
            return LineType.HeadingIndicator;
        }
        if (this.text.startsWith("---", this.leadingPosition)) {
            this.horizontalRule = this.isHorizontalRule();
            return LineType.HeadingIndicator;
        }
        if (this.text.startsWith("[", this.leadingPosition)) {
            return LineType.LinkReference;
        }
        if (this.text.startsWith(">", this.leadingPosition)) {
            return LineType.BlockQuote;
        }
        if (this.isUnorderedList()) {
            return LineType.UnorderedList;
        }
        if (this.lineStartsWithNumber()) {
            return LineType.OrderedList;
        }
        if (this.isHorizontalRule()) {
            return LineType.HRule;
        }
        return LineType.UnknownText;
    }

    private boolean isHorizontalRule() {
        if (MarkupUtils.isOnlySpaceAndCharacter(this.text, '-')) {
            if (this.text.startsWith("---", this.leadingPosition)) {
                return true;
            }
            if (this.text.startsWith("- - -", this.leadingPosition)) {
                return true;
            }
        }
        if (MarkupUtils.isOnlySpaceAndCharacter(this.text, '*')) {
            if (this.text.startsWith("***", this.leadingPosition)) {
                return true;
            }
            if (this.text.startsWith("* * *", this.leadingPosition)) {
                return true;
            }
        }
        if (MarkupUtils.isOnlySpaceAndCharacter(this.text, '_')) {
            if (this.text.startsWith("___", this.leadingPosition)) {
                return true;
            }
            if (this.text.startsWith("_ _ _", this.leadingPosition)) {
                return true;
            }
        }
        return false;
    }

    public boolean lineStartsWithNumber() {
        int dot = this.text.indexOf(46);
        if (dot == -1) {
            return false;
        }
        try {
            Integer.parseInt(this.text.substring(0, dot));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean isUnorderedList() {
        return (this.isUnorderedListOfChar('*') || this.isUnorderedListOfChar('+') || this.isUnorderedListOfChar('-')) && !this.isHorizontalRule();
    }

    private boolean isUnorderedListOfChar(char terminator) {
        return (this.text.startsWith(terminator + " ", this.leadingPosition) || this.text.startsWith(terminator + "\t", this.leadingPosition)) && !MarkupUtils.isOnlySpaceAndCharacter(this.text, terminator);
    }

    public String substring(int index) {
        return this.text.substring(index);
    }

    public String substring(int start, int end) {
        return this.text.substring(start, end);
    }

    public int indexOf(char c) {
        return this.text.indexOf(c);
    }

    public int indexOf(char c, int startIndex) {
        return this.text.indexOf(c, startIndex);
    }

    public boolean startsWith(String str) {
        return this.text.startsWith(str);
    }

    public boolean startsWith(char c) {
        return this.text.startsWith(String.valueOf(c));
    }

    public boolean endsWith(String str) {
        return this.text.endsWith(str);
    }

    public char charAt(int index) {
        return this.text.charAt(index);
    }

    public TextLine trim() {
        this.text = this.text.trim();
        return this;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }
}

