/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz;

import com.sangupta.nutz.MarkupUtils;
import com.sangupta.nutz.ProcessingOptions;
import com.sangupta.nutz.TextLine;
import com.sangupta.nutz.TextNodeParser;
import com.sangupta.nutz.ast.AbstractListNode;
import com.sangupta.nutz.ast.BlockQuoteNode;
import com.sangupta.nutz.ast.CodeBlockNode;
import com.sangupta.nutz.ast.HRuleNode;
import com.sangupta.nutz.ast.HeadingNode;
import com.sangupta.nutz.ast.LineType;
import com.sangupta.nutz.ast.ListItemNode;
import com.sangupta.nutz.ast.NewLineNode;
import com.sangupta.nutz.ast.Node;
import com.sangupta.nutz.ast.OrderedListNode;
import com.sangupta.nutz.ast.ParagraphNode;
import com.sangupta.nutz.ast.PlainTextNode;
import com.sangupta.nutz.ast.RootNode;
import com.sangupta.nutz.ast.UnorderedListNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class Parser {
    protected BufferedReader reader = null;
    protected TextLine line = null;
    protected final RootNode ROOT_NODE = new RootNode();
    protected StringBuilder collector = new StringBuilder(1024);
    protected Node lastNode = null;
    protected TextNodeParser textNodeParser;
    protected ProcessingOptions options = null;

    public Parser() {
        this.options = new ProcessingOptions();
        this.reset();
    }

    public Parser(ProcessingOptions processingOptions) {
        this.options = processingOptions;
        this.reset();
    }

    protected void reset() {
        this.line = null;
        this.lastNode = null;
        this.collector.setLength(0);
        if (this.ROOT_NODE.getReferenceLinks() != null) {
            this.ROOT_NODE.getReferenceLinks().clear();
        }
        if (this.ROOT_NODE.getChildren() != null) {
            this.ROOT_NODE.getChildren().clear();
        }
    }

    public RootNode parse(String markup) throws IOException {
        this.reader = new BufferedReader(new StringReader(markup));
        this.reset();
        this.readLines(this.ROOT_NODE);
        return this.ROOT_NODE;
    }

    public RootNode parse(Reader reader) throws IOException {
        if (!(reader instanceof BufferedReader)) {
            this.reader = new BufferedReader(reader);
        }
        this.reset();
        this.readLines(this.ROOT_NODE);
        return this.ROOT_NODE;
    }

    protected void readLines(Node root) throws IOException {
        if (this.textNodeParser == null) {
            this.textNodeParser = new TextNodeParser();
        }
        this.lastNode = null;
        this.collector.setLength(0);
        TextLine currentLine = new TextLine("", this.options);
        while (true) {
            if (this.line == null || this.line == currentLine) {
                this.readLine();
            }
            currentLine = this.line;
            if (this.line.isNull) {
                return;
            }
            this.lastNode = this.parseLine(root);
            if (this.lastNode == null) continue;
            root.addChild(this.lastNode);
        }
    }

    protected void readLine() throws IOException {
        this.line = new TextLine(this.reader.readLine(), this.options);
    }

    protected Node parseLine(Node currentRoot) throws IOException {
        LineType lineType = this.line.lineType;
        switch (lineType) {
            case HtmlComment: {
                return this.parseText(currentRoot, true);
            }
            case Heading: {
                return this.parseHeading(currentRoot);
            }
            case FencedCodeBlock: {
                return this.parseFencedCodeBlock();
            }
            case HeadingIndicator: {
                if (this.lastNode instanceof ParagraphNode) {
                    boolean broken;
                    int style = 1;
                    if (this.line.charAt(this.line.leadingPosition) == '-') {
                        style = 2;
                    }
                    if (broken = ((ParagraphNode)this.lastNode).breakIntoTextAndHeading(style)) {
                        return null;
                    }
                }
                if (this.line.horizontalRule) {
                    return new HRuleNode();
                }
            }
            case UnorderedList: {
                return this.parseList(currentRoot, false);
            }
            case OrderedList: {
                return this.parseList(currentRoot, true);
            }
            case HRule: {
                return new HRuleNode();
            }
            case CodeBlock: {
                return this.parseVerbatimBlock();
            }
            case BlockQuote: {
                String blockText = this.parseBlockText();
                RootNode rootNode = new Parser().parse(blockText);
                return new BlockQuoteNode(rootNode);
            }
            case Empty: {
                return new PlainTextNode(currentRoot, "\n");
            }
            case LinkReference: {
                boolean found = this.parseLinkReference();
                if (found) {
                    return null;
                }
            }
            case UnknownText: {
                return this.parseText(currentRoot, true);
            }
            case Xml: {
                throw new IllegalArgumentException("This case has never been coded");
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CodeBlockNode parseVerbatimBlock() throws IOException {
        if (this.line.trimEmpty) {
            return null;
        }
        String lang = null;
        boolean firstLine = true;
        this.collector.setLength(0);
        int empty = 0;
        block4: while (true) {
            int spaceIndex;
            int index;
            if (firstLine && (index = this.line.trim().indexOf('!')) != -1 && (spaceIndex = this.line.indexOf(' ', index + 1)) == -1) {
                lang = this.line.substring(0, index).trim();
            }
            if (!firstLine || lang == null) {
                this.collector.append(this.line);
                this.collector.append('\n');
            }
            firstLine = false;
            this.readLine();
            if (this.line.isNull) return new CodeBlockNode(this.collector.toString().trim(), lang);
            switch (this.line.lineType) {
                case CodeBlock: {
                    empty = 0;
                    continue block4;
                }
                case Empty: {
                    if (++empty >= 2) return new CodeBlockNode(this.collector.toString().trim(), lang);
                    continue block4;
                }
                default: {
                    return new CodeBlockNode(this.collector.toString().trim(), lang);
                }
            }
            break;
        }
    }

    protected boolean parseLinkReference() {
        int index = this.line.indexOf(']');
        if (index == -1) {
            return false;
        }
        if (this.line.charAt(index + 1) != ':') {
            return false;
        }
        String id = this.line.substring(this.line.leadingPosition + 1, index);
        String link = this.line.substring(index + 2).trim();
        String[] tokens = MarkupUtils.parseLinkAndTitle(link);
        this.ROOT_NODE.addReferenceLink(id, tokens[0].trim(), tokens[1]);
        return true;
    }

    protected Node parseList(Node currentRoot, boolean ordered) throws IOException {
        LineType lineType;
        AbstractListNode listNode = ordered ? new OrderedListNode() : new UnorderedListNode();
        int thisListsLeadingPosition = this.line.leadingPosition;
        StringBuilder collector = new StringBuilder(512);
        int looseEntries = 0;
        int empty = 0;
        ListItemNode lastChildNode = null;
        boolean hangingText = false;
        block9: while ((lineType = this.line.lineType) != null) {
            if (lineType == LineType.CodeBlock) {
                if (this.line.isUnorderedList()) {
                    lineType = LineType.UnorderedList;
                } else if (this.line.lineStartsWithNumber()) {
                    lineType = LineType.OrderedList;
                }
            }
            switch (lineType) {
                case UnorderedList: 
                case OrderedList: {
                    String text;
                    if (collector.length() > 0) {
                        text = collector.toString();
                        collector.setLength(0);
                        if (listNode.getChildren() == null && empty > 0) {
                            listNode.setLooseItems(true);
                        }
                        lastChildNode = (ListItemNode)this.textNodeParser.parse(listNode, new ListItemNode(listNode), text);
                        if (!hangingText) {
                            listNode.addChild(lastChildNode);
                        } else {
                            listNode.lastNode().addChild(lastChildNode);
                        }
                        hangingText = false;
                    }
                    if (this.line.leadingPosition > thisListsLeadingPosition) {
                        Node childList = this.parseList(listNode, this.line.lineType == LineType.OrderedList);
                        Node currentElementInList = listNode.lastNode();
                        currentElementInList.addChild(childList);
                        switch (this.line.lineType) {
                            case UnorderedList: 
                            case OrderedList: {
                                continue block9;
                            }
                            case CodeBlock: 
                            case UnknownText: {
                                hangingText = true;
                                continue block9;
                            }
                        }
                        break block9;
                    }
                    if (this.line.leadingPosition < thisListsLeadingPosition) break block9;
                    text = this.line.getText();
                    int start = this.line.leadingPosition + 1;
                    if (ordered) {
                        int dot = this.line.indexOf('.');
                        start = dot + 1;
                    } else {
                        start = this.line.leadingPosition + 1;
                    }
                    text = MarkupUtils.isWhiteSpace(text.charAt(start)) ? text.substring(++start) : text.substring(start);
                    collector.append(text);
                    collector.append('\n');
                    empty = 0;
                    break;
                }
                case CodeBlock: 
                case UnknownText: {
                    if (this.line.leadingPosition <= thisListsLeadingPosition || empty != 0 && (lineType != LineType.CodeBlock || empty >= 2)) break block9;
                    collector.append(this.line.getText());
                    collector.append('\n');
                    empty = 0;
                    break;
                }
                case Empty: {
                    ++empty;
                    ++looseEntries;
                    collector.append(this.line.getText());
                    collector.append('\n');
                    if (empty != 2) break;
                    break block9;
                }
                default: {
                    break block9;
                }
            }
            this.readLine();
            if (!this.line.isNull) continue;
            break;
        }
        if (collector.length() > 0) {
            String text = collector.toString();
            if (looseEntries == empty) {
                while (text.endsWith("\n\n")) {
                    text = text.substring(0, text.length() - 1);
                }
            }
            lastChildNode = (ListItemNode)this.textNodeParser.parse(listNode, new ListItemNode(listNode), text);
            if (!hangingText) {
                listNode.addChild(lastChildNode);
            } else {
                listNode.lastNode().addChild(lastChildNode);
            }
        }
        return listNode;
    }

    protected CodeBlockNode parseFencedCodeBlock() throws IOException {
        String language = null;
        char terminator = this.line.terminator;
        if (this.line.length > 3) {
            language = this.line.substring(3);
        }
        this.collector.setLength(0);
        while (true) {
            this.readLine();
            if (this.line.isNull || this.line.startsWith(terminator)) break;
            this.collector.append(this.line);
            this.collector.append("\n");
        }
        this.readLine();
        CodeBlockNode codeBlock = new CodeBlockNode(this.collector.toString().trim(), language);
        return codeBlock;
    }

    protected HeadingNode parseHeading(Node currentRoot) throws IOException {
        int headCount = 1;
        int index = 1;
        while (this.line.charAt(index) == '#') {
            ++headCount;
            ++index;
        }
        this.line.trim();
        index = this.line.length;
        while (this.line.charAt(index - 1) == '#') {
            --index;
        }
        this.line = new TextLine(this.line.substring(headCount, index).trim(), this.options);
        Node textNode = this.parseText(currentRoot, false);
        HeadingNode heading = new HeadingNode(headCount, textNode);
        this.line = null;
        return heading;
    }

    protected Node parseText(Node currentRoot, boolean fetchMoreLines) throws IOException {
        if (!fetchMoreLines) {
            return this.textNodeParser.parse(currentRoot, this.line.getText());
        }
        if (this.line.trimEmpty) {
            return new NewLineNode(currentRoot);
        }
        this.collector.setLength(0);
        while (!this.line.isEmpty) {
            this.collector.append(this.line.getText());
            this.collector.append('\n');
            if (this.line.endsWith("  ")) {
                this.line = new TextLine(this.reader.readLine(), this.options);
                break;
            }
            this.line = new TextLine(this.reader.readLine(), this.options);
            if (this.line != null && !this.line.isEmpty && !this.line.trimEmpty && !this.line.startsWith("===") && !this.line.startsWith("---")) continue;
            break;
        }
        return this.textNodeParser.parse(currentRoot, this.collector.toString());
    }

    protected String parseBlockText() throws IOException {
        StringBuilder builder = new StringBuilder(1024);
        int index = -1;
        do {
            if ((index = this.line.indexOf('>')) >= 0) {
                String text = ++index < this.line.length && this.line.charAt(index) == ' ' ? this.line.substring(index + 1) : this.line.substring(index);
                builder.append(text);
                builder.append('\n');
            }
            this.readLine();
        } while (!this.line.isNull && index >= 0);
        return builder.toString();
    }
}

