/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz;

import java.util.Arrays;
import java.util.Stack;

public class MarkupUtils {
    public static boolean isEmail(String text) {
        return text.contains("@") && text.contains(".");
    }

    public static boolean isHyperLink(String text) {
        return text.contains("://") && text.contains(".");
    }

    public static String[] parseLinkAndTitle(String link) {
        String[] tokens = new String[2];
        int index = link.indexOf(32);
        int tabIndex = link.indexOf(9);
        if (tabIndex >= 0 && tabIndex < index) {
            index = tabIndex;
        }
        if (index == -1) {
            tokens[0] = link;
        } else {
            String text = link.substring(index).trim();
            if (text.charAt(0) == '\"') {
                int pos = index;
                index = text.lastIndexOf(34);
                if (index == -1) {
                    index = text.length();
                } else if (index + 1 != text.length()) {
                    index = text.length();
                }
                tokens[0] = link.substring(0, pos);
                tokens[1] = text.substring(1, index);
            }
        }
        String token = tokens[0];
        if (!token.isEmpty() && token.charAt(0) == '<' && token.charAt(token.length() - 1) == '>') {
            tokens[0] = token.substring(1, token.length() - 1);
        }
        return tokens;
    }

    public static int[] findLeadingSpaces(String line) {
        int[] array = new int[]{0, 0};
        if (line.isEmpty()) {
            return array;
        }
        int index = 0;
        int spaces = 0;
        while (index < line.length()) {
            char c = line.charAt(index);
            if (c == ' ') {
                ++index;
                ++spaces;
                continue;
            }
            if (c != '\t') break;
            ++index;
            spaces += 4;
        }
        array[0] = index;
        array[1] = spaces;
        return array;
    }

    public static int indexOfSkippingForPairCharacter(String line, char terminator, char terminatorPair, int startIndex) {
        char[] array = line.toCharArray();
        int length = array.length;
        int open = 1;
        do {
            char c;
            if ((c = array[startIndex++]) == terminator) {
                --open;
            } else if (c == terminatorPair) {
                ++open;
            }
            if (open != 0) continue;
            return startIndex - 1;
        } while (startIndex != length);
        return -1;
    }

    public static boolean isOnlySpaceAndCharacter(String line, char character) {
        char[] array = line.toCharArray();
        block3: for (int index = 0; index < array.length; ++index) {
            char c = array[index];
            switch (c) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    if (c == character) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    public static int indexOfMultiple(String line, char character, int count, int startIndex) {
        if (count == 1) {
            return line.indexOf(character, startIndex);
        }
        char[] array = new char[count];
        Arrays.fill(array, character);
        String search = String.valueOf(array);
        return line.indexOf(search, startIndex);
    }

    public static int findEndingTagPosition(String line, int pos, String tagName) {
        int maxEndIndex = line.length() - (tagName.length() + 3);
        String tag = null;
        Stack<String> stack = new Stack<String>();
        stack.push(tagName);
        for (int index = pos; index <= maxEndIndex; ++index) {
            char ch = line.charAt(index);
            if (ch == '<') {
                int nextIndex;
                if (line.charAt(index + 1) == '!') {
                    nextIndex = line.indexOf("-->", index);
                    if (nextIndex == -1) {
                        return -1;
                    }
                    index = nextIndex + 2;
                    continue;
                }
                if (line.charAt(index + 1) == '/') {
                    nextIndex = line.indexOf(">", index);
                    tag = line.substring(index + 2, nextIndex);
                    do {
                        if (!stack.isEmpty()) continue;
                        return -1;
                    } while (!((String)stack.pop()).equals(tag));
                    if (stack.isEmpty()) {
                        return line.indexOf(62, index + 1) + 1;
                    }
                    index = nextIndex;
                    continue;
                }
                nextIndex = line.indexOf(32, index);
                int nextIndex2 = line.indexOf(62, index);
                if (nextIndex2 != -1 && nextIndex != -1) {
                    if (nextIndex2 < nextIndex) {
                        nextIndex = nextIndex2;
                    }
                } else {
                    if (nextIndex == -1 && nextIndex2 == -1) continue;
                    if (nextIndex == -1) {
                        nextIndex = nextIndex2;
                    }
                }
                tag = line.substring(index + 1, nextIndex);
                stack.push(tag);
                index = nextIndex;
                continue;
            }
            if (ch != '/' || line.charAt(index + 1) != '>') continue;
            stack.pop();
            if (!stack.isEmpty()) continue;
            return index + 2;
        }
        return -1;
    }

    public static boolean isSingularHtmlElement(String tagName) {
        if ("hr".equals(tagName)) {
            return true;
        }
        return "br".equals(tagName);
    }

    public static boolean isWhiteSpace(char ch) {
        switch (ch) {
            case '\t': 
            case ' ': {
                return true;
            }
        }
        return false;
    }
}

