/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.nutz;

import com.sangupta.nutz.HtmlEmitter;
import com.sangupta.nutz.Parser;
import com.sangupta.nutz.ProcessingOptions;
import com.sangupta.nutz.ast.RootNode;
import java.io.IOException;
import java.io.Reader;

public class MarkdownProcessor {
    private final HtmlEmitter htmlEmitter;
    private final ProcessingOptions options;

    public MarkdownProcessor() {
        this(new ProcessingOptions());
    }

    public MarkdownProcessor(ProcessingOptions options) {
        this.options = options;
        this.htmlEmitter = new HtmlEmitter(options);
    }

    private Parser createParser() {
        return new Parser(this.options);
    }

    public RootNode parse(String markup) throws IOException {
        return this.createParser().parse(markup);
    }

    public RootNode parse(Reader reader) throws IOException {
        return this.createParser().parse(reader);
    }

    public String toHtml(String markup) throws IOException {
        RootNode node = this.createParser().parse(markup);
        return this.htmlEmitter.toHtml(node);
    }

    public static String toHtml(String markup, ProcessingOptions options) throws IOException {
        RootNode node = new Parser(options).parse(markup);
        return new HtmlEmitter(options).toHtml(node);
    }

    public String toHtml(Reader reader) throws IOException {
        RootNode node = this.createParser().parse(reader);
        return this.htmlEmitter.toHtml(node);
    }

    public static String toHtml(Reader reader, ProcessingOptions options) throws IOException {
        RootNode node = new Parser(options).parse(reader);
        return new HtmlEmitter(options).toHtml(node);
    }

    public <T extends Appendable> T toHtml(Reader reader, T writer) throws IOException {
        RootNode node = this.createParser().parse(reader);
        return this.htmlEmitter.toHtml(node, writer);
    }

    public <T extends Appendable> T toHtml(Reader reader, T writer, ProcessingOptions options) throws IOException {
        RootNode node = this.createParser().parse(reader);
        return new HtmlEmitter(options).toHtml(node, writer);
    }
}

