/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.DefaultExternalProcessFactory;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessConfigurer;
import com.atlassian.utils.process.ExternalProcessSettings;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;

public class ConfigurableExternalProcessFactory
extends DefaultExternalProcessFactory {
    private List<ExternalProcessConfigurer> configurers = new CopyOnWriteArrayList<ExternalProcessConfigurer>();

    public ConfigurableExternalProcessFactory() {
    }

    public ConfigurableExternalProcessFactory(ExecutorService executorService) {
        super(executorService);
    }

    @Override
    @Nonnull
    public ExternalProcess create(@Nonnull ExternalProcessSettings settings) {
        for (ExternalProcessConfigurer configurer : this.configurers) {
            configurer.configure(settings);
        }
        return super.create(settings);
    }

    public void addConfigurer(@Nonnull ExternalProcessConfigurer configurer) {
        this.configurers.add(configurer);
    }

    public void setConfigurers(@Nonnull List<ExternalProcessConfigurer> configurers) {
        this.configurers = new CopyOnWriteArrayList<ExternalProcessConfigurer>(configurers);
    }
}

