define("cq/widget/watch-view",
    [
        "jquery",
        "cq"
    ],
    function (
        $,
        CQ) {

        return CQ.View.extend({
            events: {
                "click": "toggleWatch"
            },

            initialize: function() {
                _.bindAll(this, "toggleWatch");
                this.model.on("change:isWatching", this.update, this);

                this.observeAjaxRequests();
            },

            render: function() {
                // TODO render template if el not set
                return this;
            },

            update: function(model, isWatching) {
                this.$(".cq-watch-label").html(CQ.Templates.widget.watchLabel({isWatching: isWatching, type: model.get("type")}));
                this.$el.attr("data-is-watching", isWatching);
            },

            toggleWatch: function(e) {
                e.preventDefault();

                this.model.toggleWatch();
            }
        });
    });