/**
 * Vote button interface.
 *
 * Wire up an existing button:
 *
 * var vote = new Vote({el: el});
 * where el is an element that is a result of rendering the vote button soy template.
 *
 * OR
 *
 * Create a new vote button based on the passed in option object (not implemented yet):
 *
 * var vote = new Vote({
 *  id: 1234, // answer id
 *  type: "answer", // you can only vote for answer at the moment
 *  hasVoted: true | false, // user has voted
 *  total: 42 // num votes
 * });
 *
 * vote.render();
 *
 */
define("cq/widget/vote",
    [
        "jquery",
        "cq/util/events",
        "cq/util/analytics",
        "cq/widget/vote-view",
        "cq/widget/vote-model"
    ],
    function (
        $,
        events,
        analytics,
        VoteView,
        VoteModel) {

        function Vote(options) {
            var el = options.el;
            if (el) {
                var $el = $(el);
                options.id = $el.data("id");
                options.type = $el.data("type");
                options.voted = $el.data("voted");
                options.total = $el.data("total");
                delete options.el; // don't pass el to the model.
            }

            var model = new VoteModel(options);
            var view = new VoteView({model: model, el: el});

            // analytics
            model.on("change:voted", function (model, voteDirection, data) {
                if (!data.revert) {
                    analytics.trackEvent(model.get("type"), voteDirection + "vote", {
                        totalVotes: model.get("total")
                    });
                }
            });

            return {
                model: model,
                view: view,
                render: function() {
                    return view.render();
                }
            }
        }

        return Vote;
    });