define("cq/widget/vote-view",
    [
        "jquery",
        "cq",
        "cq/util/events",
        "cq/widget/notifications"
    ],
    function (
        $,
        CQ,
        events,
        notifications) {

        return CQ.View.extend({
            events: {
                "click .cq-up": "upVoteClicked",
                "click .cq-down": "downVoteClicked"
            },

            initialize: function() {
                _.bindAll(this, "upVoteClicked", "downVoteClicked");

                this.model.on("change:voted", this.update, this);
                this.model.on("change:total", this.updateTotal, this);
                this.model.on("vote-error", this.showVoteError, this);

                this.observeAjaxRequests();
            },

            render: function() {
                // TODO render template if el not set
                return this;
            },

            update: function(model, voted) {
                this.$el.attr("data-voted", voted);
            },

            updateTotal: function(model, total) {
                this.$el.attr("data-total", total);
            },

            downVoteClicked: function(e) {
                e.preventDefault();

                this.model.toggleDownVote();
            },

            upVoteClicked: function(e) {
                e.preventDefault();

                this.model.toggleUpVote();
            },

            showVoteError: function(model, response, direction) {
                notifications.notify({
                    type: response.type || "warning",
                    body: response.errorMessage,
                    errorKey: response.errorKey
                });
            }
        });
    });