define("cq/widget/vote-model",
    [
        "jquery",
        "backbone",
        "ajs",
        "cq/util/analytics"
    ],
    function (
        $,
        Backbone,
        AJS,
        analytics) {

        return Backbone.Model.extend({
            url: function(direction) {
                return AJS.contextPath() + "/rest/questions/1.0/" + this.get("type") + "/" + this.get("id") + "/vote/" + direction;
            },

            vote: function(direction, method, countChange) {
                var self = this;
                if (!AJS.Meta.get("remote-user")) {
                    self.trigger("vote-anonymous-error", self, direction);
                    return;
                }

                var voted = this.get("voted");
                var total = this.get("total");

                self.trigger("request", self);
                $.ajax({
                    url: this.url(direction),
                    type: method,
                    dataType: "json"
                }).done(function () {
                    self.trigger("sync", self);
                }).error(function (jqXhr) {
                    self.set("voted", voted, { revert: true });
                    self.set("total", total);
                    self.trigger("error", self);

                    if (jqXhr.status === 401) {
                        var response = JSON.parse(jqXhr.responseText);
                        self.trigger("vote-error", self, response, direction);

                        analytics.trackEvent("vote", direction + "vote-own-" + self.get("type"));
                    }
                });

                this.set("voted", method == "POST" ? direction : "none");
                this.set("total", total + countChange);
            },

            toggleUpVote: function() {
                var voted = this.get("voted");
                switch (voted) {
                    case "none":
                        this.vote("up", "POST", 1);
                        break;
                    case "up":
                        this.vote("up", "DELETE", -1);
                        break;
                    case "down":
                        this.vote("down", "DELETE", 1);
                        break;
                }
            },

            toggleDownVote: function() {
                var voted = this.get("voted");
                switch (voted) {
                    case "none":
                        this.vote("down", "POST", -1);
                        break;
                    case "up":
                        this.vote("up", "DELETE", -1);
                        break;
                    case "down":
                        this.vote("down", "DELETE", 1);
                        break;
                }
            }
        });
    });
