require([
    "jquery",
    "underscore",
    "cq",
    "cq/util/analytics",
    "cq/widget/notifications",
    "cq/widget/topicwatchers",
    "cq/widget/topicwatchers-view"
], function (
    $,
    _,
    CQ,
    analytics,
    notifications,
    TopicWatchers,
    TopicWatchersView) {

    var SidebarTopicWatchersView = TopicWatchersView.extend({
        render: function() {
            var template = CQ.Templates.widget.topicWatchers.topicWatchers({watchers: this.collection.toJSON()});
            this.$el.html(template);

            return this;
        }
    });

    $(function () {
        $(".cq-topic-watchers-summary").on("click", ".cq-topic-stats-doedit", function () {
            var $parentContainer = $(this).closest(".cq-topic-watchers-summary");
            var $watchers = $parentContainer.find(".cq-watchers");
            var topicId = $parentContainer.data("topic-id");

            var topicWatchers = new TopicWatchers([], {
                topicId: topicId
            });

            topicWatchers.fetch({reset: true});
            topicWatchers.on("reset", function () {
                var topicWatchersView = new SidebarTopicWatchersView({
                    collection: topicWatchers
                });

                topicWatchersView.on("done", function (e) {
                    var dfd = $.getJSON(AJS.contextPath() + "/rest/questions/1.0/topic/" + topicId + "/stats");
                    dfd.done(function (data) {
                        var template = CQ.Templates.widget.topicWatchersSummary.iconView({ topicStats: data });
                        $watchers.html(template);
                    });

                    // show spinner
                    $(".cq-topic-stats-edit").html(CQ.Templates.widget.topicWatchersSummary.spinner());
                });

                $watchers.html(topicWatchersView.render().el);
                topicWatchersView.$("input").focus();

                Confluence.Binder.autocompleteUserOrGroup($parentContainer)
            });

            // show spinner
            $(".cq-topic-stats-edit").html(CQ.Templates.widget.topicWatchersSummary.spinner());
            analytics.trackEvent("topic", "edit-watchers-click");
        });
    });
});