define("cq/widget/topicwatchers",
    [
        "jquery",
        "underscore",
        "cq"
    ],
    function (
        $,
        _,
        CQ) {


    var TopicWatcher = CQ.Model.extend({
        idAttribute: "userKey"
    });

    return CQ.Collection.extend({
        model: TopicWatcher,
        url: function() {
            return AJS.contextPath() + "/rest/questions/1.0/topic/" + this.topicId + "/watch";
        },

        initialize: function(models, options) {
            this.topicId = options.topicId;

            this.on("add", this.addWatcher, this);
            this.on("remove", this.removeWatcher, this);
        },

        addWatcher: function(watcher) {
            this.updateWatcher(watcher, "POST");
        },

        removeWatcher: function(watcher) {
            this.updateWatcher(watcher, "DELETE");
        },

        updateWatcher: function(watcher, method) {
            var self = this;
            this.trigger("request", this);

            $.ajax({
                url: this.url() + "/" + watcher.id,
                type: method,
                dataType: "json"
            }).done(function () {
                self.trigger("sync", self);
            }).error(function () {
                self.trigger("error", self);
            });
        }
    });
});
