define("cq/widget/topicwatchers-view",
    [
        "jquery",
        "underscore",
        "cq",
        "cq/util/analytics",
        "cq/widget/notifications"
    ],
    function (
        $,
        _,
        CQ,
        analytics,
        notifications) {


    return CQ.View.extend({
        className: "cq-edit-watchers",
        events: {
            "click .cq-topic-stats-edit-done" : "done",
            "selected.autocomplete-user" : "userSelected",
            "submit form" : "cancelFormSubmit",
            "click .cq-remove": "removeWatcher",
            "keydown .cq-search-user" : "inputEntered"
        },

        initialize: function() {
            this.collection.on("add", this.add, this);
            this.collection.on("remove", this.remove, this);

            this.collection.on("add remove", this.updateWatchersCount, this);
            this.observeAjaxRequests();
        },

        render: function() {
            var template = CQ.Templates.widget.topicWatchers.topicWatchers({watchers: this.collection.toJSON()});
            this.$el.html(template);

            return this;
        },

        add: function(user) {
            var template = CQ.Templates.widget.topicWatchers.user({user: user.toJSON()});

            // fade in user
            var $user = $(template).css("opacity", 0);
            this.$(".cq-user-list ul").prepend($user);
            $user.animate({opacity: 1}, 400);
        },

        remove: function(user) {
            var $el = this.$(".cq-user-list").find("[data-user-key=" + user.id + "]");

            // animate removal
            $el.animate({opacity: 0}, 200, "linear", function () {
                $(this).animate({height: 0, 'padding-bottom': 0}, 300, "linear", function () {
                    $(this).remove();
                });
            });
        },

        removeWatcher: function(e) {
            e.preventDefault();

            var $closest = $(e.target).closest(".cq-watcher");
            var key = $closest.data("user-key");
            this.collection.remove(key);
            analytics.trackEvent("topic", "watcher-removed");
        },

        updateWatchersCount: function() {
            this.$(".cq-watchers-count").html(this.collection.length);
        },

        /**
         * Intercept the return key on the user search input field. For some very strange reason it calls
         * removeWatcher because it reckons the user clicked on the remove button? wat.
         *
         * @param e
         */
        inputEntered: function(e) {
            if (e.which === 13) {
                e.preventDefault();
            }
        },

        userSelected: function(e, data) {
            e.preventDefault();
            var user = data.content;

            // strip host and context path from thumbnailLink
            var avatarDownloadPath = user.thumbnailLink.href;
            var contextPathEnd = avatarDownloadPath.indexOf(AJS.contextPath()) + AJS.contextPath().length;
            avatarDownloadPath = avatarDownloadPath.substring(contextPathEnd);

            var userAlreadyWatching = this.collection.get(user.userKey);
            if (userAlreadyWatching) {
                this.notifyWhenUserAlreadyWatching();
            } else {
                // map autocomplete user model to cq model
                this.collection.unshift({
                    avatarDownloadPath: avatarDownloadPath,
                    fullName: user.title,
                    name: user.username,
                    userKey: user.userKey
                });
            }

            this.$("input").val("").focus();
            analytics.trackEvent("topic", "watcher-added");
        },

        notifyWhenUserAlreadyWatching: function() {
            notifications.notify({
                body: AJS.I18n.getText("cq.topicstatistics.already-watching")
            });
        },

        done: function(e) {
            this.trigger("done", e);
        },

        cancelFormSubmit: function(e) {
            e.preventDefault();
            return false;
        }
    });
});