define("cq/widget/topics-selector",
        [
            "jquery",
            "underscore",
            "backbone",
            "cq/util/events",
            "exports"
        ],
function (
        $,
        _,
        Backbone,
        events,
        exports) {

    function initSelect2($el) {
        var lastResults = [];

        var maxSuggestions = 10;
        $el.removeClass("hidden").auiSelect2({
            multiple: true,
            tokenSeparators: [",", " "],
            placeholder: AJS.I18n.getText('cq.question.ask.topics.input.placeholder'),
            maximumInputLength: 150,
            quietMillis: 200,
            ajax: {
                url: AJS.contextPath() + "/rest/questions/1.0/topic/suggest",
                data: function(searchTerm, page) {
                    if (searchTerm.length < 2) {
                        searchTerm = "";
                    }

                    return {
                        query: $.trim(searchTerm),
                        page: page - 1,
                        maxSuggestions: maxSuggestions
                    }
                },
                results: function (topicInfos) {
                    lastResults = _.map(topicInfos, function(topicInfo) {
                        return {
                            id: topicInfo.topic.name,
                            text: topicInfo.topic.name,
                            questionsCount: topicInfo.questionsCount,
                            metadata: AJS.I18n.getText("cq.question.ask.topics.topic.metadata.questions", topicInfo.questionsCount)
                        }
                    });
                    return {
                        results: lastResults,
                        more: topicInfos.length == maxSuggestions
                    };
                },
                quietMillis: 300
            },
            createSearchChoice: function(term, data) {

                var trimmedTerm = $.trim(term);
                var itemComparator = function (item) { return item.text.localeCompare(trimmedTerm) == 0; };

                // createSearchChoice is called by the default tokenizer when typing "," or " "
                // we need to check if the term was returned during the previous search
                if (_.filter(lastResults, itemComparator).length > 0) {
                    return {
                        id: trimmedTerm,
                        text: trimmedTerm
                    };
                }

                // createSearchChoice is also called after an ajax query
                // if the searched term is not in data then it's a new topic
                if (data.length < maxSuggestions && _.filter(data, itemComparator).length == 0) {
                    return {
                        id: trimmedTerm,
                        text: trimmedTerm,
                        metadata: AJS.I18n.getText("cq.question.ask.topics.create.new.topic"),
                        newTopic: true
                    };
                }
            },
            initSelection: function(element, callback) {
                var data = [];
                $(element.val().split(",")).each(function () {
                    data.push({id: this, text: this});
                });
                callback(data);
            },
            formatResult: function (result, container, query, escapeMarkup)
            {
                var formattedResult = $.fn.select2.defaults.formatResult(result, container, query, escapeMarkup);
                if (result.metadata !== undefined)
                {
                    formattedResult += "<span class='cq-topic-metadata'>" + result.metadata + "</span>";
                }
                return formattedResult;
            },
            sortResults: function (results, container, query) {
                if (results.length > 0 && results[0].newTopic) {
                    var newTopic = results.shift();
                    results.push(newTopic);
                }

                return results;
            }
        });
    }

    exports.initSelector = function($el) {
        initSelect2($el);
    }
});