define("cq/widget/topics-model",
    [
        "jquery",
        "backbone",
        "cq/util/events"
    ],
    function (
        $,
        Backbone,
        events) {

        return Backbone.Model.extend({

            url: function() {
                return AJS.contextPath() + "/rest/questions/1.0/questions/" + this.get("id") + "/topics";
            },

            getTopics: function() {
                var self = this;
                var getTopics = $.getJSON(AJS.contextPath() + "/rest/questions/1.0/topic/suggest?query=");
                this.trigger("request:topics");

                getTopics.done(function (data) {
                    var topics = _.pluck(data, "topic");
                    self.trigger("sync:topics", self, topics);
                });
            },

            validate: function(attrs, options) {
                if (attrs.topics.trim() == "") {
                    return "Topics cannot be empty";
                }
            },

            /**
             * Trigger custom save event. Mimics the 'request' event from backbone 1.0 but use custom
             * name to avoid problems in environments where 'request' is properly implemented (e.g.
             * Confluence versions with AUI 5.2+)
             */
            save: function() {
                var xhr = Backbone.Model.prototype.save.apply(this, arguments);

                if (xhr) {
                    this.trigger('cq-request', this, xhr);
                    return xhr;
                }
            }
        });
    });