define("cq/widget/tooltips", [ "jquery", "underscore", "exports" ],
    function ($, _, exports) {

        var DEFAULTS = {
            delayIn: 500,
            delayOut: 500,
            offset: 3,
            gravity: "n",
            opacity: 1 // to make it easier to read white text
        };

        /**
         * Makes tipsy tooltips in the given context.
         *
         * @param context
         */
        exports.initialize = function(context) {
            if (_.isString(context)) {
                context = $(context);
            }

            context.find(".cq-tooltip").each(function () {
                var $this = $(this);
                var options = _.clone(DEFAULTS);
                var gravity = $this.data("tooltip-gravity");

                if (gravity) {
                    options.gravity = gravity;
                }

                $this.tipsy(options);
            });
        };

        exports.DEFAULTS = DEFAULTS;
    });
