define("cq/widget/sidebarrss",
    [
        "jquery",
        "underscore",
        "cq/widget/filters",
        "uri",
        "exports"
    ],
    function (
            $,
            _,
            filters,
            Uri,
            exports) {

        function updateRssUrl(newUri) {
            newUri.addQueryParam("type", "rss");
            newUri.addQueryParam("os_authType", "basic");
            $(".cq-rss-link").attr("href", newUri.toString());
        }

        function trackFilterChange()
        {
            filters.on("change", function (filter, href) {
                var newUri = new Uri(href);
                updateRssUrl(newUri);
            });
        }

        exports.onReady = function() {
            $(function () {
                trackFilterChange();
            });
        };
    });