define("cq/widget/sidebarquestion",
        [
            "ajs",
            "jquery",
            "underscore",
            "backbone",
            "cq/api/search",
            "cq/widget/query-input",
            "cq/layout/sidebar",
            "cq/util/util",
            "cq/widget/loading",
            "cq/api/question-service",
        ],
        function (
                AJS,
                $,
                _,
                BackBone,
                Search,
                QueryInput,
                sidebar,
                util,
                loadingUtil,
                questionService) {
            var SideBarQuestion = BackBone.View.extend({
                template: CQ.Templates.widget.sidebarQuestionsItems,
                el: ".cq-sidebar-questions-list",
                showRelatedQuestionForViewQuestion: function () {
                    var $sidebarquestion = $(this.el);
                    var questionId = $sidebarquestion.data("question-id");
                    var topicName = $sidebarquestion.data("topic-name");
                    var sectionSpinner = new loadingUtil.SectionSpinner($("#cq-sidebar-group"), "cq-widget-loading-indicator");
                    var dfd = questionService.getRelatedQuestions(questionId, topicName);
                    sectionSpinner.showUntilResolved(dfd);
                    dfd.done(_.bind(this.renderData, this));
                    dfd.fail(function() {
                        // Render an error message
                        $sidebarquestion.html(CQ.Templates.widget.sidebarQuestionsErrorMessage());
                    });
                },
                showRelatedQuestionsForAskQuestion: function () {
                    var $titleInput = $("#cq-question-title");
                    var $group;

                    function renderResults(results) {
                        if (!$group) {
                            // initial rendering, no group yet
                            var template = CQ.Templates.widget.sidebarQuestions({
                                title: AJS.I18n.getText("cq.sidebar.ask.relatedquestions.title")
                            });

                            $group = sidebar.addGroup(template).hide().fadeIn(500);
                        }
                        if (results.length > 0) {
                            $(".cq-sidebar-questions").removeClass("hidden");
                        }
                        // update only the list inside the group with new results
                        $group.find(".cq-sidebar-questions-list").fadeOut(200, function () {
                            $(this).html(CQ.Templates.widget.sidebarQuestionsItems({
                                questions: results
                            })).fadeIn(500)
                        });
                    }

                    // react to changes to the input field and fire off searches
                    var queryInput = new QueryInput({
                        el: $titleInput
                    });
                    queryInput.on("change", util.wait(function (val) {
                        if (val.length > 3) {
                            search.query({query: val});
                        }
                    }, 1000, this));

                    // we will render the 5 incoming search results
                    var search = new Search();
                    search.on("respond", function (query) {
                        if (query.results.length === 0) {
                            return;
                        }

                        renderResults(_.first(query.results, 5));
                    });

                    // initial search if we start off with a non-empty title field
                    var input = $titleInput.val();
                    if (input.length > 3) {
                        search.query({query: input});
                    }
                },
                renderData: function (results) {
                    if (results.length > 0) {
                        $(".cq-sidebar-questions").removeClass("hidden");
                        this.$el.html(this.template({questions: results}));
                    }
                }
            });
            return SideBarQuestion;
        });
