require(["jquery", "cq/util/analytics"], function($, analytics) {
    AJS.toInit(function () {
        var $shareButton = $(".cq-share-button");

        if (!AJS.params.pageId) {
            AJS.params.pageId = AJS.Meta.get('pageId');
        }

        if (AJS.Confluence.SharePage) {
            AJS.Confluence.SharePage.initDialog($shareButton, "shareContentPopup", {offsetX: -110});
        }

        // analytics
        $shareButton.on("click", function() {
            analytics.trackEvent("question", "shareclick");
        });

        $(document).on("click", "#inline-dialog-shareContentPopup .submit", function() {
            analytics.trackEvent("question", "sharesubmit");
        });

        if (typeof AJS.HelpTip !== 'undefined' && $shareButton.length) { // Check that the help tips plugin is available.
            var helpTipInfo = {
                id: "cq.feature.discovery.share",
                body: CQ.Templates.widget.shareFeatureDiscoveryDialogBody(),
                anchor: $shareButton
            };

            var helpTip = new AJS.HelpTip(helpTipInfo);

            helpTip.show();
            $shareButton.click(function () {
                helpTip.dismiss();
            });
        }
    });
});
