(function($) {

    function getQueryStringParams(url) {
        var regex = /[?&;]*(.*?)=([^&;]*)/g;
        var match;
        var params = {};

        while (match = regex.exec(url)) {
            params[match[1]] = match[2].replace(/\+/g, " ");
        }

        return params;
    }

    function setButtonTitle(title) {
        var href = AJS.contextPath() + "/questions/ask?src=search&title=" + title;
        $("#cq-search-ask-a-question-button").attr("href", href);
    }


    // set query string from initial server search
    $(function () {
        var params = getQueryStringParams(window.location.search);
        var queryString = params["queryString"];
        if (queryString) {
            setButtonTitle(queryString);
        }
    });

    // keep button updated when ajax search changes
    AJS.bind("search-start", function (e, params) {
        var queryString = params.queryString;
        if (queryString) {
            setButtonTitle(encodeURIComponent(queryString));
        }
    });
}(AJS.$));