require([
    "jquery",
    "cq/util/analytics",
    "cq/widget/loading"
], function (
    $,
    analytics,
    loading) {

    function getStats() {
        return $.ajax({
            url: AJS.contextPath() + "/rest/questions/1.0/statistics",
            type: "GET",
            cache: false,
            dataType: "json",
            data: {
                statistics: ["questions_per_day", "answered_ratio"]
            }
        });
    }

    function renderStats(stats) {
        $(".cq-instancestats").hide().html(CQ.Templates.widget.instanceStats.statsSummary({stats: stats})).fadeIn(400);
    }

    $(function() {
        if (AJS.Meta.get("cq-is-admin")) {
            var statsDfd = getStats();
            statsDfd.done(renderStats);

            var sectionSpinner = new loading.SectionSpinner($(".cq-instancestats"));
            sectionSpinner.showUntilResolved(statsDfd);

            $(document).on("click", ".cq-instancestats .cq-see-more-link", function () {
                analytics.trackEvent("statistics", "viewmoreclick");
            });
        }
    });
});