define("cq/widget/experts",
    [
        "jquery",
        "underscore",
        "cq/widget/loading",
        "cq/api/expert-service",
        "exports"
    ],
    function (
        $,
        _,
        loadingUtil,
        expertService,
        exports) {

        function buildQuery(ajaxPageSize, startIndex, topicId, spaceId) {
            var query = {
                startIndex: startIndex,
                pageSize: ajaxPageSize
            };
            if (topicId) {
                query.topicId = topicId;
            }

            if (spaceId) {
                query.spaceId = spaceId;
            }
            return query;
        }

        exports.onReady = function () {
            var $expertsWidget = $(".cq-experts-widget");
            $(function () {
                var topicId = $expertsWidget.data("topic-id");
                var spaceId = $expertsWidget.data("space-id");
                var NUMBER_OF_EXPERTS = 10;
                var query = buildQuery(NUMBER_OF_EXPERTS, 0, topicId, spaceId);
                var sectionSpinner = new loadingUtil.SectionSpinner($expertsWidget, "cq-widget-loading-indicator");
                var dfd = expertService.getExperts(query);
                sectionSpinner.showUntilResolved(dfd);
                dfd.done(renderData);
                dfd.fail(function() {
                    // Render an error message
                    $expertsWidget.html(CQ.Templates.widget.expertsErrorMessage());
                });
                $expertsWidget.attr("data-ajax-request", true);
                dfd.always(function () {
                    $expertsWidget.attr("data-ajax-request", false);
                });
            });

            function renderData(experts) {
                var html = experts.length > 0 ? CQ.Templates.widget.experts({experts: experts.toJSON()}, null) : CQ.Templates.widget.expertsBlank();
                $expertsWidget.hide().html(html).fadeIn(400);
            }
        };
    }
);
