define("cq/editor/autosave/indicator",
        [
            "jquery",
            "underscore",
            "backbone",
        ],function (
                $,
                _,
                Backbone) {
            'use strict';

            var SAVING_CLASSES = "aui-icon aui-icon-small aui-icon-wait";
            var SAVED_CLASSES = "aui-icon aui-icon-small aui-iconfont-approve";
            var ERRORED_CLASSES = "aui-icon aui-icon-small aui-iconfont-error";

            var $statusMessage;
            var $statusIcon;

            return Backbone.View.extend({
                initialize: function() {
                    var that = this;

                    this.$el.show();
                    this.$el.append(CQ.Templates.widget.autoSaveStatusIndicator());

                    $statusMessage = this.$(".cq-status-indicator-message");
                    $statusIcon = this.$(".cq-status-indicator-icon");
                },
                showSavingIndicator: function (){
                    $statusIcon.removeClass(SAVED_CLASSES);
                    $statusIcon.addClass(SAVING_CLASSES);
                    $statusMessage.text(AJS.I18n.getText("cq.editor.status.saving"));

                },
                showSavedIndicator: function (){
                    $statusIcon.removeClass(SAVING_CLASSES);
                    $statusIcon.addClass(SAVED_CLASSES);
                    $statusMessage.text(AJS.I18n.getText("cq.editor.status.saved"));
                },
                showErrorIndicator: function (){
                    $statusIcon.removeClass(SAVING_CLASSES);
                    $statusIcon.removeClass(SAVED_CLASSES);
                    $statusIcon.addClass(ERRORED_CLASSES);
                    $statusMessage.text(AJS.I18n.getText("cq.editor.status.saved.error"));
                }
            });

        });