define("cq/widget/editor/toolbar",
        [
            "jquery",
            "exports"
        ],
        function ($, exports) {
            exports.onReady = function() {
                AJS.toInit(function () {

                    $("#rte-button-insert-image").click(function() {
                            if ($(this).hasClass("disabled")) {
                                return;
                            }

                            Confluence.Editor.defaultInsertImageDialog();
                        }
                    );

                    /**
                     * Hide the "From the Web" and "Search" tabs for now as they don't work too well in CQ
                     */
                    (Confluence.Editor.ImageDialog.beforeShowListeners || {}).push(function () {
                        var $dialog = $("#insert-image-dialog");
                        $dialog.attr("data-lasttab-override", "true");
                        $dialog.find(".page-menu-item:eq(0) button").click();
                        $dialog.find(".dialog-page-menu").remove();
                    });

                    $("#rte-button-insert-code").click(function () {
                        if ($(this).hasClass("disabled")) {
                            return;
                        }

                        tinymce.confluence.MacroUtils.insertMacro({
                            contentId: "0",
                            macro: {
                                name: "code",
                                body: tinyMCE.activeEditor.selection.getContent({format : 'text'})
                            }
                        });
                    });

                    $("#rte-button-insert-link").click(function () {
                        if ($(this).hasClass("disabled")) {
                            return;
                        }

                        AJS.Rte.getEditor().execCommand("mceConflink");
                    });
                });

            };
        });
