// modelled after confluence-paste/confluencepaste.js from core
(function ($) {
    AJS.bind("init.rte", function () {
        var handler = function (uri, node, done) {
            if (!isConfluence(uri)) {
                done();
                return;
            }

            function resolveId(id) {
                if (!id) {
                    done();
                }

                var wikiIdMarkup = "[$" + id + "]";
                tinymce.plugins.Autoconvert.getHtmlFromWikiMarkup(
                    wikiIdMarkup,
                    function (data) {
                        done($(data).children()[0]);
                    },
                    function () {
                        done();
                    });
            }

            var path = uri.path;
            var isActionUrl = path.indexOf(".action") !== -1;

            // handle pretty url and non-pretty url case
            if (isActionUrl) {
                // http://localhost:8080/confluence/cq/viewquestion.action?id=983353&questionTitle=guitars-staircase-sports-car-pool-dress-ask
                var id = uri.queryKey["id"];
                resolveId(id);
            } else {
                // http://localhost:8080/confluence/questions/983353/guitars-staircase-sports-car-pool-dress-ask
                var idMatch = path.match(/questions\/([\d]+)/);
                if (idMatch && idMatch.length === 2) {
                    var id = idMatch[1];
                    resolveId(id);
                } else {
                    done();
                }
            }
        };

        var isConfluence = function (uri) {
            var isConfluence = true;
            isConfluence = isConfluence && uri.authority === document.location.host;
            isConfluence = isConfluence && (!AJS.contextPath() || uri.path.indexOf(AJS.contextPath()) === 0);
            return isConfluence;
        };

        try {
            tinymce.plugins.Autoconvert.autoConvert.addHandler(handler);
        } catch (e) {
            AJS.error("Failed to add questions autoconvert handler", e);
        }
    });
})(AJS.$);
