/**
 * Tracks events via Atlassian Analytics.
 */
require(["cq/util/analytics", "ajs"], function (analytics, AJS) {
        analytics.addMapper({
            pageview: function () {
                var path = analytics.sanitizePath();

                var spaceId = AJS.Meta.get("space-id");
                if (spaceId) {
                    this.event('spacepage', 'view', {
                        page: path,
                        spaceId: spaceId
                    });
                } else {
                    this.event('page', 'view', {page: path});
                }
                this.sourceview();
            },
            sourceview: function () {
                var src = AJS.Meta.get("question-view-src");
                var questionId = AJS.Meta.get("question-id");
                if (src) {
                    this.event("src", src, {id: questionId})
                }
            }
            ,
            event: function (noun, verb, data) {
                var name = ['cq', noun, verb].join('.');
                var obj = {name: name};
                if (data) {
                    obj.data = data;
                }

                var logMsg = "***** Analytics log [" + name + "]";
                if (data) {
                    logMsg += "[" + JSON.stringify(data) + "]";
                }
                console && console.log(logMsg);

                // Do the actual tracking
                AJS.trigger("analytics", obj);
            }
        });
    });