require([
        "internal/browser-metrics",
        "jquery",
        "ajs"],
    function (
        metrics,
        $,
        AJS) {
        function measure() {
            var path = window.location.pathname.
                    substring(AJS.Meta.get('context-path').length + 1). // drop context path + "/"
                    split('?', 1)[0]; // drop optional parameters
            if (path.indexOf("questions") == 0) { // in Global Questions Dashboard
                var tokens = path.split("/");
                switch (tokens.length) {
                    case 1:
                        console.log("metrics.start: confluence.questions.questions.view");
                        metrics.start({
                            key: "confluence.questions.questions.view",
                            ready: ".cq-questionlist",
                            isInitial: true
                        });
                        break;
                    case 2:
                        switch (tokens[1]) {
                            case "topics":
                                console.log("metrics.start: confluence.questions.topics.view");
                                metrics.start({
                                    key: "confluence.questions.topics.view",
                                    ready: "#cq-topiclist-outer",
                                    isInitial: true
                                });
                                break;
                            case "experts":
                                console.log("metrics.start: confluence.questions.experts.view");
                                metrics.start({
                                    key: "confluence.questions.experts.view",
                                    ready: "#cq-experts-all",
                                    isInitial: true
                                });
                                break;
                            case "stats":
                                console.log("metrics.start: confluence.questions.stats.view");
                                metrics.start({
                                    key: "confluence.questions.stats.view",
                                    ready: ".cq-stats",
                                    isInitial: true
                                });
                                break;
                        }
                        break;
                    case 4:
                        if (tokens[1] === "topics") { // view questions in a topic
                            var questionId = Number(tokens[2]);
                            if (questionId !== NaN) {
                                console.log("metrics.start: confluence.questions.topics.questions.view");
                                metrics.start({
                                    key: "confluence.questions.topics.questions.view",
                                    ready: ".cq-questionlist",
                                    isInitial: true
                                });
                            }
                        }
                }
            }
        }

        AJS.toInit(measure);
    }
);