define("cq/feature/viewquestion/topic-suggestions",
    [
        "jquery",
        "underscore",
        "cq/util/analytics",
        "cq/widget/notifications",
        "cq/widget/watch-model",
        "exports"
    ],
    function (
        $,
        _,
        analytics,
        notifications,
        WatchModel,
        exports) {

        function watchTopic(topic) {
            var watchModel = new WatchModel({
                id: topic.id,
                type: "topic",
                isWatching: false
            });

            watchModel.on("sync", function () {
                notifications.notify({
                    type: "success",
                    title: AJS.I18n.getText("cq.topic.watch.suggestion.notification2.title"),
                    body: CQ.Templates.feature.viewquestion.topicSuggestionsWatchSuccess({ topic: topic })
                });
            });

            watchModel.on("error", function () {
                notifications.notify({
                    type: "warning",
                    body: AJS.I18n.getText("cq.topic.watch.suggestion.error")
                });
            });

            // analytics
            watchModel.on("change:isWatching", function (model, isWatching) {
                isWatching && analytics.trackEvent("topic", "after-answer-suggestion-watch");
            });

            watchModel.toggleWatch();
        }

        function suggestTopicsToWatch() {
            var questionId = AJS.Meta.get("question-id");
            if (questionId == undefined) {
                return;
            }
            var dfd = $.getJSON(AJS.contextPath() + "/rest/questions/1.0/questions/" + questionId + "/topicSuggestions");

            dfd.done(function(topic) {

                var $message = notifications.notify({
                    type: "success",
                    title: AJS.I18n.getText("cq.topic.watch.suggestion.notification1.title"),
                    body: CQ.Templates.feature.viewquestion.topicSuggestions({ topic: topic }),
                    duration: 20,
                    fadeIn: true
                });

                analytics.trackEvent("topic", "after-answer-suggestion-show");
                $message.find(".icon-close").on("click", function() {
                    analytics.trackEvent("topic", "after-answer-suggestion-dismiss");
                });

                $message.on("click", ".cq-watch-suggested-topics-button", function () {
                    $message.fadeOut('fast', function () {
                        $(this).closeMessage();
                        watchTopic(topic);
                    });
                });
            }).fail(function() {
                console.log("Cannot get topic suggestions");
            });
        }

        exports.onReady = function() {
            $(function () {
                var suggestion = AJS.Meta.get("cq-topic-suggestion");
                if (!!suggestion) {
                    setTimeout(suggestTopicsToWatch, 2 * 1000);
                }
            });
        };
    });