define("cq/feature/viewquestion/accept-answer-link",
    [
        "jquery",
        "underscore",
        "cq",
        "cq/util/analytics",
        "cq/api/question-service",
        "exports"
    ],
    function (
        $,
        _,
        CQ,
        analytics,
        questionService,
        exports) {

        var AcceptLinkView = CQ.View.extend({
            events: {
                "click": "toggleAccepted"
            },

            initialize: function() {
                this.model.on("change:accepted", function (model, accepted) {
                    this.$el.attr("data-accepted", accepted);
                    this.$el.text(accepted ? AJS.I18n.getText("cq.question.answer.unaccept") : AJS.I18n.getText("cq.question.answer.accept"));
                }, this);

                this.observeAjaxRequests("accepted");
            },

            render: function() {
                return this;
            },

            toggleAccepted: function(e) {
                e.preventDefault();

                analytics.trackEvent("answer", "accept-link-click");
                this.model.toggleAccepted();
            }
        });

        function Accept(options) {
            var $el = $(options.el);
            var answerId = $el.data("answer-id");

            return {
                render: function () {
                    questionService.getAnswer(answerId).done(function (answer) {
                        var view = new AcceptLinkView({
                            model: answer,
                            el: options.el
                        });

                        view.render();
                    });
                }
            }
        }

        function initAcceptAnswers() {
            $(".cq-accept-answer").each(function (i, el) {
                var accept = new Accept({
                    el: this
                });

                accept.render();
            });
        }

        exports.onReady = function() {
            $(function () {
                initAcceptAnswers();
            });
        };
    });