require([
        "jquery",
        "cq/util/analytics",
        "cq/widget/watch",
        "cq/widget/infinite-list",
        "cq/api/topic-service"
    ],
    function (
        $,
        analytics,
        Watch,
        infiniteList,
        topicService
        ) {

        var PAGE_SIZE = 9;

        function TopicSelectorDialog(topics) {
            var MIN_NUMBER_OF_TOPICS_TO_WATCH = 3;

            this.topics = topics;
            this.numberOfSelectedTopics = _.where(topics, {isWatching: true}).length;

            var self = this;

            this.continueButtonLabelBySelectedTopics = {
                2: AJS.I18n.getText("cq.topic.selector.dialog.button.1.left"),
                1: AJS.I18n.getText("cq.topic.selector.dialog.button.2.left"),
                0: AJS.I18n.getText("cq.topic.selector.dialog.button.3.left")
            };

            this.show = function() {
                dialog.gotoPage(0);
                dialog.gotoPanel(0);
                dialog.show();

                infiniteList.init({
                    infinite: true,
                    $el: $(".cq-topics"),
                    load: this.getTopics,
                    render: this.renderTopic,
                    $container: $(".cq-topics-container"),
                    body: $(".cq-topics-container")[0],
                    scrollMargin: 65
                });
            };

            this.updateContinueButton = function()
            {
                var $continueButton = $("#cq-topic-selector-dialog .cq-continue-button");
                var label = this.continueButtonLabelBySelectedTopics[self.numberOfSelectedTopics];
                if (label) {
                    $continueButton.text(label);
                    $continueButton.attr("disabled", "disabled");
                } else {
                    $continueButton.text(AJS.I18n.getText("cq.topic.selector.dialog.button.0.left"));
                    $continueButton.removeAttr("disabled", "");
                }
            };

            this.updateProgressBar = function()
            {
                var $progressBar = $("#cq-topic-selector-dialog .cq-progress");
                var completion = (Math.min(MIN_NUMBER_OF_TOPICS_TO_WATCH, self.numberOfSelectedTopics) / MIN_NUMBER_OF_TOPICS_TO_WATCH) * 100;
                $progressBar.css("width", completion + "%");
                $progressBar.attr("data-progress", completion);
            };

            this.topicClickHandler = function(topic) {
                var $el = $(topic);

                $el.toggleClass("selected");
                var selected = $el.hasClass("selected");
                self.numberOfSelectedTopics += selected ? 1 : -1;

                this.updateProgressBar();
                this.updateContinueButton();

                var topicId = $el.data("topic-id");
                $.ajax({
                    url: AJS.contextPath() + "/rest/questions/1.0/topic/" + topicId + "/watch",
                    type: selected ? "POST" : "DELETE",
                    contentType: "application/json"
                });

                analytics.trackEvent("topicselector", selected ? "watch" : "unwatch");
            };

            this.continueButtonHandler = function() {
                analytics.trackEvent("topicselector", "continue");

                var dfd = this.topicSelectionIsDone();

                dfd.done(function() {
                    dialog.hide();
                });
            };

            this.skipButtonHandler = function() {
                analytics.trackEvent("topicselector", "skip");

                var dfd = this.topicSelectionIsDone();

                dfd.done(function() {
                    dialog.hide();
                });
            };

            this.watchAllButtonHandler = function(model, isWatching) {
                var text = isWatching ? AJS.I18n.getText("cq.topic.selector.dialog.watch.all.on.description") :
                                        AJS.I18n.getText("cq.topic.selector.dialog.watch.all.off.description");
                $(".cq-watch-all-bar .cq-description").text(text);

                $(".cq-topics").toggleClass("disabled");

                this.numberOfSelectedTopics += isWatching ? MIN_NUMBER_OF_TOPICS_TO_WATCH : -MIN_NUMBER_OF_TOPICS_TO_WATCH;
                this.updateProgressBar();
                this.updateContinueButton();
            };

            this.topicSelectionIsDone = function() {
                var dfd = $.ajax({
                    url: AJS.contextPath() + "/rest/questions/1.0/settings/topicselection",
                    type: "POST",
                    dataType: "json",
                    contentType: "application/json",
                    data: JSON.stringify({
                        done: true
                    })
                });

                return dfd;
            };

            this.getTopics = function(ajaxPageSize, startIndex) {
                var query = {
                    startIndex: startIndex,
                    pageSize: ajaxPageSize,
                    loadLatestQuestionTitle: true,
                    loadAvatar: true
                };
                return topicService.getTopics(query);
            };

            this.renderTopic = function(topic) {
                return CQ.Templates.feature.topicselector.topic({topicInfo: topic.toJSON()});
            };

            var dialog = new AJS.Dialog({
                width: 980,
                height: 530,
                id: "cq-topic-selector-dialog"
            });

            dialog.addHeader(AJS.I18n.getText("cq.topic.selector.dialog.title"));
            dialog.addPanel("SinglePanel", CQ.Templates.feature.topicselector.topicselector({
                topicInfos: topics,
                pageSize: PAGE_SIZE
            }));

            dialog.addButton(AJS.I18n.getText("cq.topic.selector.dialog.button.3.left"), _.bind(this.continueButtonHandler, this), "cq-continue-button");
            dialog.addLink(AJS.I18n.getText("cq.topic.selector.dialog.button.skip"), _.bind(this.skipButtonHandler, this));

            // Primary button
            var $continueButton = $("#cq-topic-selector-dialog").find(".cq-continue-button");
            $continueButton.removeClass("button-panel-button").addClass("aui-button aui-button-primary");
            $continueButton.attr("disabled", "disabled");

            // show progress bar
            var $hint = $(CQ.Templates.feature.topicselector.progressBar());
            dialog.popup.element.find(".dialog-button-panel").append($hint);

            $(".cq-topics").on("click", ".cq-topic", function() {
                self.topicClickHandler(this);
            });

            var $watchButton = $("#cq-topic-selector-dialog .cq-watch-button");
            var watch = new Watch({ el: $watchButton });
            watch.model.on("change:isWatching", _.bind(self.watchAllButtonHandler, self));
            watch.render();

            this.updateProgressBar();
            this.updateContinueButton();
        }

        function initTopicSelectorDialog() {
            var dfd = $.getJSON(AJS.contextPath() + "/rest/questions/1.0/topic", {
                pageSize: PAGE_SIZE,
            });

            dfd.done(function (topics) {
                var MIN_NUMBER_OF_TOPICS = 5;
                if (topics.length >= MIN_NUMBER_OF_TOPICS) {
                    $.getJSON(AJS.contextPath() + "/rest/questions/1.0/topic", {
                        pageSize: PAGE_SIZE,
                        loadLatestQuestionTitle: true,
                        loadAvatar: true
                    }).done(function(topics){
                        var dialog = new TopicSelectorDialog(topics);
                        dialog.show();
                    });
                }
            });
        }

        $(function () {
            var dataKey = 'com.atlassian.confluence.plugins.confluence-questions:cq.show.topic.selector.flag.show-topic-selector';
            var showTopicSelector = typeof WRM.data != 'function' ? WRM.data.claim(dataKey) : WRM.data(dataKey);
            if (showTopicSelector) {
                initTopicSelectorDialog();
            }
        });

    });
