define("cq/feature/askquestion",
    [
        "jquery",
        "cq/api/search",
        "cq/feature/askquestion/topic",
        "cq/widget/query-input",
        "cq/layout/sidebar",
        "cq/util/util",
        "cq/util/events",
        "cq/util/analytics",
        "cq/widget/spacepicker",
        "cq/widget/sidebarquestion",
        "cq/widget/editor",
        "cq/util/autosave",
        "exports"
    ],
    function (
        $,
        Search,
        askquestionTopic,
        QueryInput,
        sidebar,
        util,
        events,
        analytics,
        SpacePicker,
        SideBarQuestion,
        Editor,
        Autosave,
        exports) {

        function initRelatedQuestionsSidebar() {
            new SideBarQuestion().showRelatedQuestionsForAskQuestion();
        }

        function initSpacePicker() {
            var $spaceKey = $("#spaceKey");

            function initSpacePickerDiscovery(spacePicker) {
                if (typeof AJS.HelpTip === 'undefined') { // Check that the help tips plugin is available.
                    return;
                }

                var helpTip = new AJS.HelpTip({
                    id: "cq.space.picker.discovery",
                    body: CQ.Templates.widget.spacepicker.spacePickerDiscoveryNotification(),
                    anchor: spacePicker.getContainer()
                });

                var openingHandler = function () {
                    helpTip.dismiss();
                    $(this).off("select2-opening", openingHandler);
                };
                spacePicker.target.on("select2-opening", openingHandler);

                helpTip.show();
            }

            if ($spaceKey.length > 0) {
                var spacePicker = new SpacePicker($spaceKey, AJS.I18n.getText("cq.question.ask.spacekey.placeholder"));

                insertSpaceKeyInFormForIE($spaceKey);

                spacePicker.on("change", function () {
                                analytics.trackEvent("spacepicker", "change");
                            });

                initSpacePickerDiscovery(spacePicker);
            }
        }

        function initHiddenSpaceKey() {
            var $spaceKey = $("input[name='spaceKey']");

            if ($spaceKey.length) {
                insertSpaceKeyInFormForIE($spaceKey);
            }
        }

        // IE doesn't support the HTML5 'form' attribute on INPUT elements
        // Workaround this by moving element into form so it will be submitted with the rest of the form
        function insertSpaceKeyInFormForIE($spaceKey) {
            if (util.isIE()) {
                $spaceKey.appendTo("#cq-question-form");
            }
        }

        function activateAutoSave(eventName, type) {
            if ("ASK" !== type)
                return;

            var $draftId = $("input[name='draftId']");
            var draftId = $draftId.val();
            var isEditQuestion = AJS.Meta.get('question-edit');
            var editingQuestionId = AJS.Meta.get('question-id');
            var spaceKey = AJS.Meta.get('space-key');
            var reloadUrl = '/questions/';
            if (spaceKey) {
                // in space
                reloadUrl = '/display/' + spaceKey + reloadUrl
            }

            if (isEditQuestion) {
                // editing not creating
                reloadUrl = reloadUrl + editingQuestionId + "/edit?draftId=";
            } else {
                reloadUrl = reloadUrl + "ask?draftId=";
            }

            if (draftId){
                // enable autosave
                Autosave.initAutoSave({
                    draftId: draftId,
                    saveUrl: "/rest/questions/1.0/questions/questionDraft/",
                    draftStoreKey: editingQuestionId ? "edit-question-draft" : "question-draft",
                    reloadUrl: reloadUrl,
                    $saveForm: $('#cq-question-form'),
                    dataExtractor: function (latestContent) {
                        var $title = $("input.cq-question-title");
                        var $topics = $("input.cq-question-topics");
                        var topics = [];
                        $.each($topics.val().split(','), function(index, item){
                            if (!item || item === '')
                                return;

                            var topic = {
                                id: "",
                                name : item
                            }

                            topics.push(topic);
                        });

                        var questionTitle = $title.val();
                        var draftData = {
                            title: questionTitle,
                            body: latestContent,
                        };

                        if (topics || topics.length > 0)
                        {
                            draftData.topics = topics;
                        }

                        return draftData;
                    },
                    pollingInterval: 5
                });
            }
        }

        exports.onReady = function() {
            askquestionTopic.onReady();

            $(function() {
                initRelatedQuestionsSidebar();
                initSpacePicker();
                initHiddenSpaceKey();
                $("#cq-question-title").addClass("cq-question-title-ready");
                AJS.bind("cq-editor-ready", activateAutoSave);
                new Editor({el: ".cq-editor-wrapper", $container : $(".cq-askquestion .cq-editor-wrapper"), type : "ASK"}).createEditor();
            });
        };
    });
