define("cq/api/topic",
    [
        "jquery",
        "underscore",
        "cq/api/base-model",
        "cq/util/analytics"
    ],
    function (
        $,
        _,
        BaseModel,
        analytics) {

        var Topic = BaseModel.extend({

            toggleWatch: function () {
                var watched = this.get("accepted");
                var self = this;

                this.trigger("request:accepted", this);
                $.ajax({
                    url: this.url() + "/accept",
                    type: watched ? "DELETE" : "POST",
                    dataType: "json"
                }).done(function () {
                        analytics.trackEvent("answer", watched ? "unaccepted" : "accepted");

                        self.trigger("sync:accepted", self);
                    }).error(function () {
                        self.set("accepted", watched);
                        self.trigger("error:accepted", self);
                    });

                this.set("accepted", !watched);
            }
        });

        return Topic;
    }
);