define("cq/api/topic-service",
    [
        "jquery",
        "underscore",
        "cq/api/topic",
        "cq/api/topic-collection"
    ],
    function (
        $,
        _,
        Topic,
        TopicCollection) {

        function TopicService(topics) {
            this.topics = topics;

            /**
             * Look up a topic via id. Will store every topic client side inside the topics collection
             * and only perform an ajax call when the topic is not found locally.
             *
             * @param id
             * @returns {$.Deferred}
             */
            this.getTopic = function(id) {
                var self = this;
                var dfd = new $.Deferred();

                var topic = this.topics.get(id);
                if (topic) {
                    dfd.resolve(topic);
                } else {
                    new Topic({id: id}).fetch({
                        success: function (topic) {
                            self.topics.add(topic);
                            dfd.resolve(topic);
                        },
                        error: function () { dfd.reject(); }
                    });
                }

                return dfd;
            };

            this.getTopics = function (query) {
                var dfd = new $.Deferred();

                new TopicCollection().fetch({
                    data: query,
                    success: function (collection) {
                        dfd.resolve(collection);
                    },
                    error: function () {
                        dfd.reject();
                    }
                });

                return dfd;
            };

            this.addTopic = function(topic) {
                this.topics.add(topic);
            };

            this.deleteTopic = function(id) {

                var dfd = new $.Deferred();
                var topic = this.topics.get(id);
                if (!topic) {
                    topic = new Topic({id: id});
                }

                topic.destroy({
                    url: AJS.contextPath() + "/rest/questions/1.0/topic/" + id,
                    success: function(model, response) {
                        dfd.resolve(model, response);
                    },
                    error: function() {
                        dfd.reject();
                    }
                });

                return dfd;
            };
        }

        return new TopicService(new TopicCollection());
    });