define("cq/api/question",
    [
        "jquery",
        "underscore",
        "cq/api/base-model",
        "cq/api/answer-collection"
    ],
    function (
        $,
        _,
        BaseModel,
        AnswerCollection) {

        var Question = BaseModel.extend({
            urlRoot: AJS.contextPath() + "/rest/questions/1.0/questions/",

            initialize: function() {
                this.set("idAsString", this.get("id") + "");
                this.answers = this.answers || new AnswerCollection();
                this.answers.url = _.bind(function () {
                    return this.url() + "/answers";
                }, this);

                this.answers.on("change:accepted", this.setAcceptedAnswerId, this);
            },

            // synchronize the one accepted answer.
            setAcceptedAnswerId: function(answer, accepted) {
                var previousAcceptedAnswer = this.getAnswer(this.get("acceptedAnswerId"));
                if (previousAcceptedAnswer) {
                    previousAcceptedAnswer.set("accepted", false);
                }

                var newAcceptedAnswerId = accepted ? answer.get("id") : null;
                this.set("acceptedAnswerId", newAcceptedAnswerId);
            },

            parse: function(response) {
                this.answers = new AnswerCollection(response.answers);
                return response;
            },

            getAnswer: function(id) {
                return this.answers.find(function (answer) {
                    return answer.get("id") === id;
                });
            }
        });

        return Question;
    });