define("cq/api/question-service",
    [
        "ajs",
        "jquery",
        "underscore",
        "cq/api/question",
        "cq/api/question-collection",
        "cq/api/answer-collection"
    ],
    function (
        AJS,
        $,
        _,
        Question,
        QuestionCollection,
        AnswerCollection) {

        function QuestionService(questions) {
            this.questions = questions;

            /**
             * Look up a question via id. Will store every question client side inside the questions collection
             * and only perform an ajax call when the question is not found locally.
             *
             * @param id
             * @returns {$.Deferred}
             */
            this.getQuestion = function(id) {
                var self = this;
                var dfd = new $.Deferred();

                var question = this.questions.get(id);
                if (question) {
                    dfd.resolve(question);
                } else {
                    new Question({id: id}).fetch({
                        success: function (question) {
                            self.questions.add(question);
                            dfd.resolve(question);
                        },
                        error: function () { dfd.reject(); }
                    });
                }

                return dfd;
            };

            this.getQuestions = function (query) {
                var dfd = new $.Deferred();

                new QuestionCollection().fetch({
                    data: query,
                    success: function (collection) {
                        dfd.resolve(collection);
                    },
                    error: function () {
                        dfd.reject();
                    }
                });

                return dfd;
            };

            this.getRelatedQuestions = function (questionId, topicName) {
                return $.ajax({
                    url: AJS.contextPath() + "/rest/questions/1.0/questions/related/" + questionId + "/" + topicName,
                    cache: false,
                    type: "GET",
                    dataType: "json"
                });
            };

            this.getAnswers = function (query) {
                var dfd = new $.Deferred();

                new AnswerCollection().fetch({
                    data: query,
                    success: function (collection) {
                        dfd.resolve(collection);
                    },
                    error: function () {
                        dfd.reject();
                    }
                });

                return dfd;
            };

            /**
             * Looks up an answer via id.
             *
             * @param id
             * @returns {$.Deferred}
             */
            this.getAnswer = function(id) {
                var dfd = new $.Deferred();

                // find an answer id by looking through all questions. there might be a better way to solve this :)
                var answer = this.questions.reduce(function (found, question) {
                    if (!found) {
                        found = question.getAnswer(id);
                    }
                    return found;
                }, null);

                if (answer) {
                    dfd.resolve(answer);
                } else {
                    // TODO fetch answer from remote
                    dfd.reject();
                }


                return dfd;
            };

            this.addQuestion = function(question) {
                this.questions.add(question);
            };
        }

        return new QuestionService(new QuestionCollection());
    });