define("cq/api/expert-service",
        [
            "jquery",
            "underscore",
            "cq/api/expert",
            "cq/api/expert-collection"
        ],
    function (
            $,
            _,
            Expert,
            ExpertCollection) {

        function ExpertService() {
            this.getExperts = function (query) {
                var dfd = new $.Deferred();

                new ExpertCollection().fetch({
                    data: query,
                    success: function (collection) {
                        dfd.resolve(collection);
                    },
                    error: function () {
                        dfd.reject();
                    }
                });

                return dfd;
            };

            this.getExpertsForPeriod = function(time, limit) {
                return $.ajax({
                    url: AJS.contextPath() + "/rest/questions/1.0/experts/period/" + time + "?limit=" + limit,
                    cache: false,
                    type: "GET",
                    dataType: "json"
                });
            };
        }

        return new ExpertService();
    }
);