/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfDcState;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import com.benryan.graphics.wmf.records.RecordCreationException;
import java.awt.Graphics2D;
import java.awt.Point;

public class MfCmdTextOut
extends MfCmd {
    private int x;
    private int y;
    private String text;
    private int count;
    private int scaled_x;
    private int scaled_y;

    @Override
    public void replay(WmfFile file) {
        Point p = this.getScaledDestination();
        int x = p.x;
        int y = p.y;
        Graphics2D graphics = file.getGraphics2D();
        MfDcState state = file.getCurrentState();
        state.prepareDrawText();
        graphics.drawString(this.text, x, y);
        state.postDrawText();
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdTextOut();
    }

    @Override
    public int getFunction() {
        return 1313;
    }

    @Override
    public void setRecord(MfRecord record) {
        int count = record.getParam(0);
        byte[] text = new byte[count];
        for (int i = 0; i < count; ++i) {
            text[i] = (byte)record.getByte(MfRecord.RECORD_HEADER_SIZE + 2 + i);
        }
        String sText = new String(text);
        int y = record.getParam((int)(Math.ceil(count / 2) + 1.0));
        int x = record.getParam((int)(Math.ceil(count / 2) + 2.0));
        this.setCount(count);
        this.setDestination(x, y);
        this.setText(sText);
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        String text = this.getText();
        int parCntText = (int)Math.ceil(text.length() / 2);
        MfRecord record = new MfRecord(parCntText + 3);
        record.setParam(0, text.length());
        byte[] textRaw = text.getBytes();
        for (int i = 0; i < this.count; ++i) {
            record.setByte(MfRecord.RECORD_HEADER_SIZE + 2 + i, textRaw[i]);
        }
        Point dest = this.getDestination();
        record.setParam((int)(Math.ceil(this.count / 2) + 1.0), dest.y);
        record.setParam((int)(Math.ceil(this.count / 2) + 2.0), dest.x);
        return record;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[TEXT_OUT] text=");
        b.append(this.getText());
        b.append(" destination=");
        b.append(this.getDestination());
        b.append(" count=");
        b.append(this.getCount());
        return b.toString();
    }

    public void setDestination(int x, int y) {
        this.x = x;
        this.y = y;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public Point getDestination() {
        return new Point(this.x, this.y);
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Point getScaledDestination() {
        return new Point(this.scaled_x, this.scaled_y);
    }

    @Override
    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
    }

    @Override
    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
    }
}

