/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfDcState;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import com.benryan.graphics.wmf.records.RecordCreationException;

public class MfCmdSetTextAlign
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_TEXT_ALIGNMENT = 0;
    private int textAlignMode;

    @Override
    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        state.setTextAlign(this.textAlignMode);
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdSetTextAlign();
    }

    @Override
    public void setRecord(MfRecord record) {
        int id = record.getParam(0);
        this.setTextAlignMode(id);
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(1);
        record.setParam(0, this.getTextAlignMode());
        return record;
    }

    @Override
    public int getFunction() {
        return 302;
    }

    public int getTextAlignMode() {
        return this.textAlignMode;
    }

    public void setTextAlignMode(int id) {
        this.textAlignMode = id;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[SET_TEXT_ALIGN] textAlign=");
        b.append(this.getTextAlignMode());
        return b.toString();
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }
}

