/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfDcState;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import java.awt.Point;

public class MfCmdMoveTo
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_X = 1;
    private static final int POS_Y = 0;
    private int destX;
    private int destY;
    private int scaled_destX;
    private int scaled_destY;

    @Override
    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        Point p = this.getScaledDestination();
        state.setCurPos(p.x, p.y);
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdMoveTo();
    }

    @Override
    public int getFunction() {
        return 532;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[MOVE_TO] destination=");
        b.append(this.getDestination());
        return b.toString();
    }

    public void setDestination(int x, int y) {
        this.destX = x;
        this.destY = y;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setDestination(Point p) {
        this.setDestination(p.x, p.y);
    }

    public Point getDestination() {
        return new Point(this.destX, this.destY);
    }

    public Point getScaledDestination() {
        return new Point(this.scaled_destX, this.scaled_destY);
    }

    @Override
    public void setRecord(MfRecord record) {
        int y = record.getParam(0);
        int x = record.getParam(1);
        this.setDestination(x, y);
    }

    @Override
    public MfRecord getRecord() {
        Point dest = this.getDestination();
        MfRecord record = new MfRecord(2);
        record.setParam(0, dest.y);
        record.setParam(1, dest.x);
        return record;
    }

    @Override
    protected void scaleXChanged() {
        this.scaled_destX = this.getScaledX(this.destX);
    }

    @Override
    protected void scaleYChanged() {
        this.scaled_destY = this.getScaledY(this.destY);
    }
}

