/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.RecordCreationException;
import java.awt.Rectangle;

public abstract class MfCmd {
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private int orgX;
    private int orgY;

    public abstract MfRecord getRecord() throws RecordCreationException;

    public abstract void setRecord(MfRecord var1);

    public abstract int getFunction();

    public abstract MfCmd getInstance();

    public abstract void replay(WmfFile var1);

    public void setScale(int orgX, int orgY, float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.orgX = orgX;
        this.orgY = orgY;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    protected abstract void scaleXChanged();

    protected abstract void scaleYChanged();

    protected Rectangle scaleRect(Rectangle r) {
        Rectangle retval = new Rectangle();
        retval.x = this.getScaledX(r.x);
        retval.y = this.getScaledY(r.y);
        retval.width = this.getScaledWidth(r.width);
        retval.height = this.getScaledHeight(r.height);
        return retval;
    }

    protected int getScaledWidth(int length) {
        if (length == 0) {
            return 1;
        }
        return (length = (int)((float)length * this.scaleX + 0.5f)) == 0 ? 1 : length;
    }

    protected int getScaledHeight(int length) {
        if (length == 0) {
            return 1;
        }
        return (length = (int)((float)length * this.scaleY + 0.5f)) == 0 ? 1 : length;
    }

    protected int[] applyScaleX(int[] n, int[] dest) {
        if (dest == null) {
            dest = new int[n.length];
        } else if (dest.length < n.length) {
            dest = new int[n.length];
        }
        for (int i = 0; i < n.length; ++i) {
            dest[i] = (int)((float)(n[i] - this.orgX) * this.scaleX + 0.5f);
        }
        return dest;
    }

    protected int[] applyScaleY(int[] n, int[] dest) {
        if (dest == null) {
            dest = new int[n.length];
        } else if (dest.length < n.length) {
            dest = new int[n.length];
        }
        for (int i = 0; i < n.length; ++i) {
            dest[i] = (int)((float)(n[i] - this.orgY) * this.scaleY + 0.5f);
        }
        return dest;
    }

    public int getScaledY(int y) {
        return (int)((float)(y - this.orgY) * this.scaleY + 0.5f);
    }

    public int getScaledX(int x) {
        return (int)((float)(x - this.orgX) * this.scaleX + 0.5f);
    }
}

