/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf;

import java.awt.Color;

public class GDIColor
extends Color {
    private int flags;
    public static final int PC_RESERVED = 1;
    public static final int PC_EXPLICIT = 2;
    public static final int PC_NOCOLLAPSE = 4;

    public GDIColor(int colorref) {
        this(GDIColor.getR(colorref), GDIColor.getG(colorref), GDIColor.getB(colorref), GDIColor.getFlags(colorref));
    }

    public GDIColor(int r, int g, int b, int flags) {
        super(r, g, b);
        this.flags = flags;
    }

    private static int getR(int ref) {
        int retval = ref & 0xFF;
        if (retval < 0) {
            retval += 256;
        }
        return retval;
    }

    private static int getG(int ref) {
        int retval = (ref & 0xFF00) >> 8;
        return retval;
    }

    private static int getB(int ref) {
        int retval = (ref & 0xFF0000) >> 16;
        return retval;
    }

    private static int getFlags(int ref) {
        return (ref & 0xFF000000) >> 24;
    }

    public boolean isReserved() {
        return (this.flags & 1) == 1;
    }

    public boolean isExplicit() {
        return (this.flags & 2) == 2;
    }

    public boolean isNoCollapse() {
        return (this.flags & 4) == 4;
    }

    public int getFlags() {
        return this.flags;
    }

    public static int translateColor(Color c) {
        int red = c.getRed();
        int green = c.getGreen();
        int blue = c.getBlue();
        int flags = 0;
        if (c instanceof GDIColor) {
            GDIColor gc = (GDIColor)c;
            flags = gc.getFlags();
        }
        int retval = flags;
        retval = (retval << 8) + blue;
        retval = (retval << 8) + green;
        retval = (retval << 8) + red;
        return retval;
    }
}

