/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.image.BufferedImageIcon;
import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.net.MIMEUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;

public class TestPICTClippingApp {
    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JFrame jFrame = new JFrame("PICTClipping test");
                jFrame.setDefaultCloseOperation(3);
                JLabel jLabel = new JLabel("Drop images here", 0){

                    public Dimension getPreferredSize() {
                        return new Dimension(320, 200);
                    }
                };
                jLabel.setTransferHandler(new ImageDropHandler(jLabel));
                jFrame.add(jLabel);
                jFrame.pack();
                jFrame.setLocationRelativeTo(null);
                jFrame.setVisible(true);
            }
        });
    }

    private static class ImageDropHandler
    extends TransferHandler {
        private final JLabel label;
        private final ExecutorService executor = Executors.newSingleThreadExecutor();

        public ImageDropHandler(JLabel jLabel) {
            super(null);
            this.label = jLabel;
        }

        private DataFlavor getSupportedFlavor(DataFlavor[] dataFlavorArray) {
            for (DataFlavor dataFlavor : dataFlavorArray) {
                String string = MIMEUtil.bareMIME((String)dataFlavor.getMimeType());
                if (InputStream.class.isAssignableFrom(dataFlavor.getDefaultRepresentationClass()) && ImageIO.getImageReadersByMIMEType(string).hasNext()) {
                    return dataFlavor;
                }
                if (!dataFlavor.equals(DataFlavor.javaFileListFlavor)) continue;
                return dataFlavor;
            }
            for (DataFlavor dataFlavor : dataFlavorArray) {
                System.err.printf("flavor: %s%n", dataFlavor);
            }
            return null;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return this.getSupportedFlavor(dataFlavorArray) != null;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            DataFlavor dataFlavor = this.getSupportedFlavor(dataFlavorArray);
            if (dataFlavor != null) {
                try {
                    Object object;
                    InputStream inputStream;
                    Object object2;
                    if (DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                        object2 = (List)transferable.getTransferData(dataFlavor);
                        if (object2.isEmpty()) {
                            return false;
                        }
                        inputStream = new FileInputStream((File)object2.get(0));
                    } else {
                        object2 = transferable.getTransferData(dataFlavor);
                        inputStream = (InputStream)object2;
                    }
                    object2 = ImageIO.createImageInputStream(inputStream);
                    Iterator<ImageReader> iterator = ImageIO.getImageReaders(object2);
                    if (!iterator.hasNext()) {
                        object = MIMEUtil.bareMIME((String)dataFlavor.getMimeType());
                        System.out.printf("Getting reader by MIME type (%s)...%n", object);
                        iterator = ImageIO.getImageReadersByMIMEType((String)object);
                    }
                    if (iterator.hasNext()) {
                        object = iterator.next();
                        this.executor.execute(new Runnable((ImageInputStream)object2, (ImageReader)object){
                            final /* synthetic */ ImageInputStream val$stream;
                            final /* synthetic */ ImageReader val$imageReader;
                            {
                                this.val$stream = imageInputStream;
                                this.val$imageReader = imageReader;
                            }

                            public void run() {
                                try {
                                    ImageDropHandler.this.readAndInstallImage(this.val$stream, this.val$imageReader);
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                            }
                        });
                        return true;
                    }
                    System.err.println("No reader found!");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                    throw runtimeException;
                }
            }
            return false;
        }

        private void readAndInstallImage(ImageInputStream imageInputStream, ImageReader imageReader) throws IOException {
            int n;
            imageReader.setInput(imageInputStream);
            int n2 = imageReader.getWidth(0);
            int n3 = imageReader.getHeight(0);
            ImageReadParam imageReadParam = null;
            if (n2 > 200 && n3 > 200 && (n = (int)Math.ceil((double)Math.max(n2, n3) / 200.0 / 3.0)) > 1) {
                imageReadParam = imageReader.getDefaultReadParam();
                imageReadParam.setSourceSubsampling(n, n, 0, 0);
            }
            System.out.printf("Reading %s format%s... ", imageReader.getFormatName(), imageReadParam != null ? ", sampling every " + imageReadParam.getSourceXSubsampling() + "th pixel" : "");
            final BufferedImage bufferedImage = imageReader.read(0, imageReadParam);
            System.out.printf("Done (%dx%d).%n", bufferedImage.getWidth(), bufferedImage.getHeight());
            imageReader.dispose();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    System.out.print("Scaling image... ");
                    BufferedImage bufferedImage2 = ImageDropHandler.this.box(bufferedImage, 200);
                    System.out.printf("Done (%dx%d).%n", bufferedImage2.getWidth(), bufferedImage2.getHeight());
                    ImageDropHandler.this.label.setIcon((Icon)new BufferedImageIcon(bufferedImage2));
                }
            });
        }

        private BufferedImage box(BufferedImage bufferedImage, int n) {
            BufferedImage bufferedImage2 = bufferedImage;
            if (bufferedImage2.getType() == 0) {
                try {
                    ColorConvertOp colorConvertOp = new ColorConvertOp(ColorSpace.getInstance(1000), null);
                    bufferedImage2 = colorConvertOp.filter(bufferedImage2, new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 7));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    bufferedImage2 = ImageUtil.accelerate((Image)bufferedImage2);
                }
            }
            if (bufferedImage2.getWidth() > n || bufferedImage2.getHeight() > n) {
                int n2;
                int n3;
                if (bufferedImage2.getWidth() > bufferedImage2.getHeight()) {
                    n3 = n;
                    n2 = (int)Math.round((double)n3 / ((double)bufferedImage2.getWidth() / (double)bufferedImage2.getHeight()));
                } else {
                    n2 = n;
                    n3 = (int)Math.round((double)n2 * ((double)bufferedImage2.getWidth() / (double)bufferedImage2.getHeight()));
                }
                return ImageUtil.createResampled((BufferedImage)bufferedImage2, (int)n3, (int)n2, (int)1);
            }
            return bufferedImage2;
        }
    }
}

