/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.plugins.pict.QTDecompressor;
import com.twelvemonkeys.imageio.plugins.pict.QuickTime;
import com.twelvemonkeys.io.FastByteArrayOutputStream;
import com.twelvemonkeys.io.LittleEndianDataOutputStream;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import javax.imageio.ImageIO;

final class QTBMPDecompressor
extends QTDecompressor {
    QTBMPDecompressor() {
    }

    public boolean canDecompress(QuickTime.ImageDesc imageDesc) {
        return "appl".equals(imageDesc.compressorVendor) && "WRLE".equals(imageDesc.compressorIdentifer) && "bmp ".equals(QTBMPDecompressor.idString(imageDesc.extraDesc, 4));
    }

    private static String idString(byte[] byArray, int n) {
        try {
            return new String(byArray, n, 4, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("ASCII charset must always be supported", unsupportedEncodingException);
        }
    }

    public BufferedImage decompress(QuickTime.ImageDesc imageDesc, InputStream inputStream) throws IOException {
        return ImageIO.read(new SequenceInputStream(this.fakeBMPHeader(imageDesc), inputStream));
    }

    private InputStream fakeBMPHeader(QuickTime.ImageDesc imageDesc) throws IOException {
        int n = 14;
        int n2 = 12;
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream(n + n2);
        LittleEndianDataOutputStream littleEndianDataOutputStream = new LittleEndianDataOutputStream((OutputStream)fastByteArrayOutputStream);
        littleEndianDataOutputStream.writeByte(66);
        littleEndianDataOutputStream.writeByte(77);
        littleEndianDataOutputStream.writeInt(imageDesc.dataSize + n + n2);
        littleEndianDataOutputStream.writeShort(0);
        littleEndianDataOutputStream.writeShort(0);
        littleEndianDataOutputStream.writeInt(n + n2);
        littleEndianDataOutputStream.writeInt(n2);
        littleEndianDataOutputStream.writeShort(imageDesc.width);
        littleEndianDataOutputStream.writeShort(imageDesc.height);
        littleEndianDataOutputStream.writeShort(1);
        littleEndianDataOutputStream.writeShort((int)imageDesc.depth);
        return new ByteArrayInputStream(fastByteArrayOutputStream.toByteArray());
    }
}

