/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.plugins.pict.BitMapPattern;
import com.twelvemonkeys.imageio.plugins.pict.Pattern;
import com.twelvemonkeys.imageio.plugins.pict.PixMapPattern;
import com.twelvemonkeys.imageio.plugins.pict.RGBColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.IndexColorModel;
import java.io.DataInput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.imageio.IIOException;

final class PICTUtil {
    private static final String ENC_MAC_ROMAN = "MacRoman";
    public static final String ENCODING = PICTUtil.initEncoding();

    PICTUtil() {
    }

    private static String initEncoding() {
        try {
            new String("\uf8ff".getBytes(), ENC_MAC_ROMAN);
            return ENC_MAC_ROMAN;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "ISO-8859-1";
        }
    }

    public static double readFixedPoint(DataInput dataInput) throws IOException {
        return (double)dataInput.readInt() / 65536.0;
    }

    static String readIdString(DataInput dataInput) throws IOException {
        byte[] byArray = new byte[4];
        dataInput.readFully(byArray);
        return new String(byArray, "ASCII");
    }

    public static Dimension readDimension(DataInput dataInput) throws IOException {
        short s = dataInput.readShort();
        short s2 = dataInput.readShort();
        return new Dimension(s, s2);
    }

    public static String readStr31(DataInput dataInput) throws IOException {
        String string = PICTUtil.readPascalString(dataInput);
        int n = 31 - string.length();
        if (n < 0) {
            throw new IOException("String length exceeds maximum (31): " + string.length());
        }
        dataInput.skipBytes(n);
        return string;
    }

    public static String readPascalString(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray, 0, n);
        return new String(byArray, ENCODING);
    }

    public static Pattern readPattern(DataInput dataInput) throws IOException {
        byte[] byArray = new byte[8];
        dataInput.readFully(byArray);
        return new BitMapPattern(byArray);
    }

    public static Pattern readColorPattern(DataInput dataInput) throws IOException {
        short s = dataInput.readShort();
        Pattern pattern = PICTUtil.readPattern(dataInput);
        if (s == 1) {
            throw new IIOException(String.format("QuickDraw pattern type '0x%04x' not implemented (yet)", s));
        }
        if (s != 2) {
            throw new IIOException(String.format("Unknown QuickDraw pattern type '0x%04x'", s));
        }
        Color color = PICTUtil.readRGBColor(dataInput);
        PixMapPattern pixMapPattern = new PixMapPattern(color, pattern);
        return pixMapPattern;
    }

    public static Color readRGBColor(DataInput dataInput) throws IOException {
        short s = dataInput.readShort();
        short s2 = dataInput.readShort();
        short s3 = dataInput.readShort();
        return new RGBColor(s, s2, s3);
    }

    public static IndexColorModel readColorTable(DataInput dataInput, int n) throws IOException {
        dataInput.readInt();
        dataInput.readUnsignedShort();
        int n2 = dataInput.readUnsignedShort() + 1;
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = dataInput.readUnsignedShort();
            Color color = PICTUtil.readRGBColor(dataInput);
            nArray[n3] = color.getRGB();
        }
        return new IndexColorModel(n, n2, nArray, 0, false, 1, 0);
    }
}

