/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.pict.BitMapPattern;
import com.twelvemonkeys.imageio.plugins.pict.PICTImageReaderSpi;
import com.twelvemonkeys.imageio.plugins.pict.PICTUtil;
import com.twelvemonkeys.imageio.plugins.pict.Pattern;
import com.twelvemonkeys.imageio.plugins.pict.QuickDraw;
import com.twelvemonkeys.imageio.plugins.pict.QuickDrawContext;
import com.twelvemonkeys.imageio.plugins.pict.QuickTime;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.io.enc.PackBits16Decoder;
import com.twelvemonkeys.io.enc.PackBitsDecoder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PICTImageReader
extends ImageReaderBase {
    static boolean DEBUG = false;
    private QuickDrawContext context;
    private Rectangle frame;
    private int version;
    private Point penPosition = new Point(0, 0);
    private Rectangle lastRectangle = new Rectangle(0, 0);
    private double screenImageXRatio;
    private double screenImageYRatio;
    private List<BufferedImage> images = new ArrayList<BufferedImage>();
    private long imageStartStreamPos;
    protected int picSize;
    private static final byte[] DATA_EXT_V2 = new byte[]{0, 120, 0, 0, 0, 0, 0, 108, 0, -88, 0, 17, 2, -1, 12, 0, -1, -2, 0, 0, 0, 72, 0, 0, 0, 72, 0, 0, 0, 2, 0, 2, 0, 110, 0, -86, 0, 0, 0, 30, 0, 1, 0, 10, 0, 2, 0, 2, 0, 110, 0, -86, 0, 10, 119, -35, 119, -35, 119, -35, 119, -35, 0, 52, 0, 2, 0, 2, 0, 110, 0, -86, 0, 10, -120, 34, -120, 34, -120, 34, -120, 34, 0, 92, 0, 8, 0, 8, 0, 113, 0, 26, 0, 2, 0, 2, 0, 110, 0, -86, 0, 110, 0, 2, 0, 2, 0, 84, 0, 110, 0, -86, 0, 110, 0, 2, 0, -1};
    private static final byte[] DATA_V2 = new byte[]{0, 120, 0, 2, 0, 2, 0, 110, 0, -86, 0, 17, 2, -1, 12, 0, -1, -1, -1, -1, 0, 2, 0, 0, 0, 2, 0, 0, 0, -86, 0, 0, 0, 110, 0, 0, 0, 0, 0, 0, 0, 30, 0, 1, 0, 10, 0, 2, 0, 2, 0, 110, 0, -86, 0, 10, 119, -35, 119, -35, 119, -35, 119, -35, 0, 52, 0, 2, 0, 2, 0, 110, 0, -86, 0, 10, -120, 34, -120, 34, -120, 34, -120, 34, 0, 92, 0, 8, 0, 8, 0, 113, 0, 26, 0, 2, 0, 2, 0, 110, 0, -86, 0, 110, 0, 2, 0, 2, 0, 84, 0, 110, 0, -86, 0, 110, 0, 2, 0, -1};
    private static final byte[] DATA_V1 = new byte[]{0, 79, 0, 2, 0, 2, 0, 110, 0, -86, 17, 1, 1, 0, 10, 0, 2, 0, 2, 0, 110, 0, -86, 10, 119, -35, 119, -35, 119, -35, 119, -35, 52, 0, 2, 0, 2, 0, 110, 0, -86, 10, -120, 34, -120, 34, -120, 34, -120, 34, 92, 113, 0, 26, 0, 2, 0, 2, 0, 110, 0, -86, 0, 110, 0, 2, 0, 2, 0, 84, 0, 110, 0, -86, 0, 110, 0, 2, -1};
    private static final byte[] DATA_V1_OVAL_RECT = new byte[]{0, 38, 0, 10, 0, 20, 0, -81, 0, 120, 17, 1, 1, 0, 10, 0, 0, 0, 0, 0, -6, 1, -112, 11, 0, 4, 0, 5, 64, 0, 10, 0, 20, 0, -81, 0, 120, -1};
    private static final byte[] DATA_V1_OVERPAINTED_ARC = new byte[]{0, 54, 0, 10, 0, 20, 0, -81, 0, 120, 17, 1, 1, 0, 10, 0, 0, 0, 0, 0, -6, 1, -112, 97, 0, 10, 0, 20, 0, -81, 0, 120, 0, 3, 0, 45, 8, 0, 10, 9, -86, 85, -86, 85, -86, 85, -86, 85, 105, 0, 3, 0, 45, -1};
    private static final byte[] DATA_V1_COPY_BITS = new byte[]{0, 72, 0, 10, 0, 20, 0, -81, 0, 120, 17, 1, 1, 0, 10, 0, 0, 0, 0, 0, -6, 1, -112, 49, 0, 10, 0, 20, 0, -81, 0, 120, -112, 0, 2, 0, 10, 0, 20, 0, 15, 0, 28, 0, 10, 0, 20, 0, 15, 0, 25, 0, 0, 0, 0, 0, 20, 0, 30, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1};

    public PICTImageReader() {
        this(null);
    }

    protected PICTImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    protected void resetMembers() {
        this.context = null;
        this.frame = null;
        this.images.clear();
    }

    private Rectangle getPICTFrame() throws IOException {
        if (this.frame == null) {
            this.readPICTHeader(this.imageInput);
            if (DEBUG) {
                System.out.println("Done reading PICT header!");
            }
        }
        return this.frame;
    }

    private void readPICTHeader(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.seek(0L);
        try {
            this.readPICTHeader0(imageInputStream);
        }
        catch (IIOException iIOException) {
            imageInputStream.seek(0L);
            PICTImageReader.skipNullHeader(imageInputStream);
            this.readPICTHeader0(imageInputStream);
        }
    }

    private void readPICTHeader0(ImageInputStream imageInputStream) throws IOException {
        this.picSize = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.println("picSize: " + this.picSize);
        }
        int n = imageInputStream.readUnsignedShort();
        int n2 = imageInputStream.readUnsignedShort();
        int n3 = imageInputStream.readUnsignedShort();
        int n4 = imageInputStream.readUnsignedShort();
        this.frame = new Rectangle(n2, n, n4 - n2, n3 - n);
        if (this.frame.width < 0 || this.frame.height < 0) {
            throw new IIOException("Error in PICT header: Invalid frame " + this.frame);
        }
        if (DEBUG) {
            System.out.println("frame: " + this.frame);
        }
        this.screenImageXRatio = 1.0;
        this.screenImageYRatio = 1.0;
        boolean bl = false;
        short s = imageInputStream.readShort();
        if (DEBUG) {
            System.out.println(String.format("PICT version: 0x%04x", s));
        }
        if (s == 4353) {
            this.version = 1;
        } else if (s == 17 && imageInputStream.readShort() == 767) {
            this.version = 2;
            if (imageInputStream.readShort() != 3072) {
                throw new IIOException("Error in PICT header: Invalid HeaderOp, expected 0x0c00");
            }
            int n5 = imageInputStream.readInt();
            if (DEBUG) {
                System.out.println(String.format("headerVersion: 0x%04x", n5));
            }
            if ((n5 & 0xFFFF0000) != -131072) {
                double d = PICTUtil.readFixedPoint(imageInputStream);
                double d2 = PICTUtil.readFixedPoint(imageInputStream);
                double d3 = PICTUtil.readFixedPoint(imageInputStream);
                double d4 = PICTUtil.readFixedPoint(imageInputStream);
                this.screenImageXRatio = (double)(n4 - n2) / (d3 - d2);
                this.screenImageYRatio = (double)(n3 - n) / (d4 - d);
                if (this.screenImageXRatio < 0.0 || this.screenImageYRatio < 0.0) {
                    throw new IIOException("Error in PICT header: Invalid bounds " + new Rectangle2D.Double(d2, d, d3 - d2, d4 - d));
                }
                if (DEBUG) {
                    System.out.println("bounding rect: " + new Rectangle2D.Double(d2, d, d3 - d2, d4 - d));
                }
                imageInputStream.skipBytes(4);
            } else {
                bl = true;
                double d = PICTUtil.readFixedPoint(imageInputStream);
                double d5 = PICTUtil.readFixedPoint(imageInputStream);
                if (DEBUG) {
                    System.out.println("xResolution: " + d);
                    System.out.println("yResolution: " + d5);
                }
                short s2 = imageInputStream.readShort();
                short s3 = imageInputStream.readShort();
                short s4 = imageInputStream.readShort();
                short s5 = imageInputStream.readShort();
                this.screenImageXRatio = (double)(n4 - n2) / (double)(s5 - s3);
                this.screenImageYRatio = (double)(n3 - n) / (double)(s4 - s2);
                if (this.screenImageXRatio < 0.0 || this.screenImageYRatio < 0.0) {
                    throw new IIOException("Error in PICT header: Invalid bounds " + new Rectangle2D.Double(s3, s2, s5 - s3, s4 - s2));
                }
                if (DEBUG) {
                    System.out.println("bounding rect: " + new Rectangle(s3, s2, s5 - s3, s4 - s2));
                }
                imageInputStream.skipBytes(4);
            }
            if (DEBUG) {
                System.out.println("screenImageXRatio: " + this.screenImageXRatio);
                System.out.println("screenImageYRatio: " + this.screenImageYRatio);
            }
        } else {
            throw new IIOException("Error in PICT header: Missing or unknown version information");
        }
        if (DEBUG) {
            System.out.println("Version: " + this.version + (bl ? " extended" : ""));
        }
        this.imageStartStreamPos = imageInputStream.getStreamPosition();
        imageInputStream.flushBefore(this.imageStartStreamPos);
    }

    static void skipNullHeader(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.skipBytes(512);
    }

    private void drawOnto(Graphics2D graphics2D) throws IOException {
        this.context = new QuickDrawContext(graphics2D);
        this.readPICTopcodes(this.imageInput);
        if (DEBUG) {
            System.out.println("Done reading PICT body!");
        }
    }

    private void readPICTopcodes(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.seek(this.imageStartStreamPos);
        byte[] byArray = new byte[6];
        Pattern pattern = QuickDraw.BLACK;
        Color color = Color.RED;
        Point point = new Point();
        Point point2 = new Point();
        Rectangle rectangle = new Rectangle();
        Polygon polygon = new Polygon();
        Polygon polygon2 = new Polygon();
        int n = 0;
        try {
            int n2;
            block196: do {
                if (this.version == 1) {
                    n2 = imageInputStream.readUnsignedByte();
                } else {
                    if ((imageInputStream.getStreamPosition() & 1L) > 0L) {
                        imageInputStream.readByte();
                    }
                    n2 = imageInputStream.readUnsignedShort();
                }
                switch (n2) {
                    case 0: {
                        if (!DEBUG) continue block196;
                        System.out.println("NOP");
                        break;
                    }
                    case 1: {
                        polygon2 = this.readRegion(imageInputStream, rectangle);
                        if (polygon2 == null) {
                            throw new IIOException("Could not read region");
                        }
                        if (!DEBUG) continue block196;
                        this.verboseRegionCmd("clipRgn", rectangle, polygon2);
                        break;
                    }
                    case 2: {
                        this.context.setBackgroundPattern(PICTUtil.readPattern(imageInputStream));
                        if (!DEBUG) continue block196;
                        System.out.println("bkPat");
                        break;
                    }
                    case 3: {
                        imageInputStream.readFully(new byte[2], 0, 2);
                        if (!DEBUG) continue block196;
                        System.out.println("txFont");
                        break;
                    }
                    case 4: {
                        byte by = imageInputStream.readByte();
                        if (!DEBUG) continue block196;
                        System.out.println("txFace: " + by);
                        break;
                    }
                    case 5: {
                        byte[] byArray2 = new byte[2];
                        imageInputStream.readFully(byArray2, 0, byArray2.length);
                        if (!DEBUG) continue block196;
                        System.out.println("txMode: " + byArray2[0] + ", " + byArray2[1]);
                        break;
                    }
                    case 6: {
                        imageInputStream.readFully(new byte[4], 0, 4);
                        if (!DEBUG) continue block196;
                        System.out.println("spExtra");
                        break;
                    }
                    case 7: {
                        Dimension dimension = new Dimension(imageInputStream.readUnsignedShort(), imageInputStream.readUnsignedShort());
                        this.context.setPenSize(dimension);
                        if (!DEBUG) continue block196;
                        System.out.println("pnsize: " + dimension);
                        break;
                    }
                    case 8: {
                        int n3 = imageInputStream.readUnsignedShort();
                        if (DEBUG) {
                            System.out.println("pnMode: " + n3);
                        }
                        this.context.setPenMode(n3);
                        break;
                    }
                    case 9: {
                        this.context.setPenPattern(PICTUtil.readPattern(imageInputStream));
                        if (!DEBUG) continue block196;
                        System.out.println("pnPat");
                        break;
                    }
                    case 10: {
                        pattern = PICTUtil.readPattern(imageInputStream);
                        if (!DEBUG) continue block196;
                        System.out.println("fillPat");
                        break;
                    }
                    case 11: {
                        int n4 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n5 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        point.setLocation(n5, n4);
                        if (!DEBUG) continue block196;
                        System.out.println("ovSize: " + point);
                        break;
                    }
                    case 12: {
                        int n4 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n5 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        Point point3 = new Point(n5, n4);
                        if (!DEBUG) continue block196;
                        System.out.println("Origin: " + point3);
                        break;
                    }
                    case 13: {
                        int n6 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        this.context.setTextSize(n6);
                        if (!DEBUG) continue block196;
                        System.out.println("txSize: " + n6);
                        break;
                    }
                    case 14: {
                        imageInputStream.readInt();
                        if (!DEBUG) continue block196;
                        System.out.println("fgColor");
                        break;
                    }
                    case 15: {
                        imageInputStream.readInt();
                        if (!DEBUG) continue block196;
                        System.out.println("bgColor");
                        break;
                    }
                    case 16: {
                        imageInputStream.readFully(new byte[8], 0, 8);
                        if (!DEBUG) continue block196;
                        System.out.println("txRatio");
                        break;
                    }
                    case 17: {
                        imageInputStream.readFully(new byte[1], 0, 1);
                        if (!DEBUG) continue block196;
                        System.out.println("opVersion");
                        break;
                    }
                    case 18: {
                        Pattern pattern2 = PICTUtil.readColorPattern(imageInputStream);
                        this.context.setBackgroundPattern(pattern2);
                        break;
                    }
                    case 19: {
                        Pattern pattern3 = PICTUtil.readColorPattern(imageInputStream);
                        this.context.setBackgroundPattern(pattern3);
                        break;
                    }
                    case 20: {
                        pattern = PICTUtil.readColorPattern(imageInputStream);
                        this.context.setBackgroundPattern(pattern);
                        break;
                    }
                    case 21: {
                        imageInputStream.readFully(new byte[2], 0, 2);
                        if (!DEBUG) continue block196;
                        System.out.println("opPnLocHFrac");
                        break;
                    }
                    case 22: {
                        imageInputStream.readFully(new byte[2], 0, 2);
                        if (!DEBUG) continue block196;
                        System.out.println("opChExtra");
                        break;
                    }
                    case 26: {
                        imageInputStream.readFully(byArray, 0, byArray.length);
                        Color color2 = new Color(byArray[0] & 0xFF, byArray[2] & 0xFF, byArray[4] & 0xFF);
                        if (!DEBUG) continue block196;
                        System.out.println("rgbFgColor: " + color2);
                        break;
                    }
                    case 27: {
                        imageInputStream.readFully(byArray, 0, byArray.length);
                        Color color3 = new Color(byArray[0] & 0xFF, byArray[2] & 0xFF, byArray[4] & 0xFF);
                        if (!DEBUG) continue block196;
                        System.out.println("rgbBgColor: " + color3);
                        break;
                    }
                    case 28: {
                        this.context.setPenPattern(new BitMapPattern(color));
                        if (!DEBUG) continue block196;
                        System.out.println("opHiliteMode");
                        break;
                    }
                    case 29: {
                        imageInputStream.readFully(byArray, 0, byArray.length);
                        color = new Color(byArray[0] & 0xFF, byArray[2] & 0xFF, byArray[4] & 0xFF);
                        if (!DEBUG) continue block196;
                        System.out.println("opHiliteColor: " + color);
                        break;
                    }
                    case 30: {
                        color = Color.red;
                        if (!DEBUG) continue block196;
                        System.out.println("opDefHilite");
                        break;
                    }
                    case 31: {
                        imageInputStream.readFully(byArray, 0, byArray.length);
                        if (!DEBUG) continue block196;
                        System.out.println("opOpColor");
                        break;
                    }
                    case 32: {
                        int n4 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n5 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        Point point3 = new Point(n5, n4);
                        n4 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        n5 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        this.penPosition.setLocation(n5, n4);
                        this.context.moveTo(point3);
                        this.context.lineTo(this.penPosition);
                        if (!DEBUG) continue block196;
                        System.out.println("line from: " + point3 + " to: " + this.penPosition);
                        break;
                    }
                    case 33: {
                        int n4 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n5 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        this.context.line(n5, n4);
                        if (!DEBUG) continue block196;
                        System.out.println("lineFrom to: " + this.penPosition);
                        break;
                    }
                    case 34: {
                        int n4 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n5 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        Point point3 = new Point(n5, n4);
                        n4 = this.getYPtCoord(imageInputStream.readByte());
                        n5 = this.getXPtCoord(imageInputStream.readByte());
                        Point point4 = new Point(n5, n4);
                        this.penPosition.setLocation(point3.x + point4.x, point3.y + point4.y);
                        this.context.lineTo(this.penPosition);
                        if (!DEBUG) continue block196;
                        System.out.println("Short line origin: " + point3 + ", dh,dv: " + point4);
                        break;
                    }
                    case 35: {
                        int n4 = this.getYPtCoord(imageInputStream.readByte());
                        int n5 = this.getXPtCoord(imageInputStream.readByte());
                        this.context.line(n5, n4);
                        if (!DEBUG) continue block196;
                        System.out.println("Short line from dh,dv: " + n5 + "," + n4);
                        break;
                    }
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: {
                        int n7 = imageInputStream.readUnsignedShort();
                        imageInputStream.readFully(new byte[n7], 0, n7);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 40: {
                        Point point3;
                        int n4 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n5 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        this.penPosition = point3 = new Point(n5, n4);
                        this.context.moveTo(this.penPosition);
                        String string = PICTUtil.readPascalString(imageInputStream);
                        this.context.drawString(string);
                        if (!DEBUG) continue block196;
                        System.out.println("longText origin: " + this.penPosition + ", text:" + string);
                        break;
                    }
                    case 41: {
                        int n8 = this.getXPtCoord(imageInputStream.readByte());
                        this.penPosition.translate(n8, 0);
                        this.context.moveTo(this.penPosition);
                        String string = PICTUtil.readPascalString(imageInputStream);
                        this.context.drawString(string);
                        if (!DEBUG) continue block196;
                        System.out.println("DHText dh: " + n8 + ", text:" + string);
                        break;
                    }
                    case 42: {
                        int n9 = this.getYPtCoord(imageInputStream.readByte());
                        this.penPosition.translate(0, n9);
                        this.context.moveTo(this.penPosition);
                        String string = PICTUtil.readPascalString(imageInputStream);
                        this.context.drawString(string);
                        if (!DEBUG) continue block196;
                        System.out.println("DVText dv: " + n9 + ", text:" + string);
                        break;
                    }
                    case 43: {
                        int n4 = this.getYPtCoord(imageInputStream.readByte());
                        int n5 = this.getXPtCoord(imageInputStream.readByte());
                        this.penPosition.translate(n5, n4);
                        this.context.moveTo(this.penPosition);
                        String string = PICTUtil.readPascalString(imageInputStream);
                        this.context.drawString(string);
                        if (!DEBUG) continue block196;
                        System.out.println("DHDVText penPosition: " + this.penPosition + ", text:" + string);
                        break;
                    }
                    case 44: {
                        imageInputStream.readShort();
                        imageInputStream.readUnsignedShort();
                        String string = PICTUtil.readPascalString(imageInputStream);
                        this.context.drawString(string);
                        if (!DEBUG) continue block196;
                        System.out.println("fontName: \"" + string + "\"");
                        break;
                    }
                    case 45: {
                        imageInputStream.readFully(new byte[10], 0, 10);
                        if (!DEBUG) continue block196;
                        System.out.println("opLineJustify");
                        break;
                    }
                    case 46: {
                        imageInputStream.readFully(new byte[6], 0, 6);
                        if (!DEBUG) continue block196;
                        System.out.println("glyphState");
                        break;
                    }
                    case 47: {
                        int n7 = imageInputStream.readUnsignedShort();
                        imageInputStream.readFully(new byte[n7], 0, n7);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: {
                        this.readRectangle(imageInputStream, this.lastRectangle);
                    }
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: {
                        switch (n2) {
                            case 48: 
                            case 56: {
                                this.context.frameRect(this.lastRectangle);
                                break;
                            }
                            case 49: 
                            case 57: {
                                this.context.paintRect(this.lastRectangle);
                                break;
                            }
                            case 50: 
                            case 58: {
                                this.context.eraseRect(this.lastRectangle);
                                break;
                            }
                            case 51: 
                            case 59: {
                                this.context.invertRect(this.lastRectangle);
                                break;
                            }
                            case 52: 
                            case 60: {
                                this.context.fillRect(this.lastRectangle, pattern);
                            }
                        }
                        if (!DEBUG) continue block196;
                        switch (n2) {
                            case 48: {
                                System.out.println("frameRect: " + this.lastRectangle);
                                break;
                            }
                            case 49: {
                                System.out.println("paintRect: " + this.lastRectangle);
                                break;
                            }
                            case 50: {
                                System.out.println("eraseRect: " + this.lastRectangle);
                                break;
                            }
                            case 51: {
                                System.out.println("invertRect: " + this.lastRectangle);
                                break;
                            }
                            case 52: {
                                System.out.println("fillRect: " + this.lastRectangle);
                                break;
                            }
                            case 56: {
                                System.out.println("frameSameRect: " + this.lastRectangle);
                                break;
                            }
                            case 57: {
                                System.out.println("paintSameRect: " + this.lastRectangle);
                                break;
                            }
                            case 58: {
                                System.out.println("eraseSameRect: " + this.lastRectangle);
                                break;
                            }
                            case 59: {
                                System.out.println("invertSameRect: " + this.lastRectangle);
                                break;
                            }
                            case 60: {
                                System.out.println("fillSameRect: " + this.lastRectangle);
                            }
                        }
                        continue block196;
                    }
                    case 61: 
                    case 62: 
                    case 63: {
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: {
                        this.readRectangle(imageInputStream, this.lastRectangle);
                    }
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: {
                        switch (n2) {
                            case 64: 
                            case 72: {
                                this.context.frameRoundRect(this.lastRectangle, point.x, point.y);
                                break;
                            }
                            case 65: 
                            case 73: {
                                this.context.paintRoundRect(this.lastRectangle, point.x, point.y);
                                break;
                            }
                            case 66: 
                            case 74: {
                                this.context.eraseRoundRect(this.lastRectangle, point.x, point.y);
                                break;
                            }
                            case 67: 
                            case 75: {
                                this.context.invertRoundRect(this.lastRectangle, point.x, point.y);
                                break;
                            }
                            case 68: 
                            case 76: {
                                this.context.fillRoundRect(this.lastRectangle, point.x, point.y, pattern);
                            }
                        }
                        if (!DEBUG) continue block196;
                        switch (n2) {
                            case 64: {
                                System.out.println("frameRRect: " + this.lastRectangle);
                                break;
                            }
                            case 65: {
                                System.out.println("paintRRect: " + this.lastRectangle);
                                break;
                            }
                            case 66: {
                                System.out.println("eraseRRect: " + this.lastRectangle);
                                break;
                            }
                            case 67: {
                                System.out.println("invertRRect: " + this.lastRectangle);
                                break;
                            }
                            case 68: {
                                System.out.println("fillRRect: " + this.lastRectangle);
                                break;
                            }
                            case 72: {
                                System.out.println("frameSameRRect: " + this.lastRectangle);
                                break;
                            }
                            case 73: {
                                System.out.println("paintSameRRect: " + this.lastRectangle);
                                break;
                            }
                            case 74: {
                                System.out.println("eraseSameRRect: " + this.lastRectangle);
                                break;
                            }
                            case 75: {
                                System.out.println("invertSameRRect: " + this.lastRectangle);
                                break;
                            }
                            case 76: {
                                System.out.println("fillSameRRect: " + this.lastRectangle);
                            }
                        }
                        continue block196;
                    }
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: {
                        this.readRectangle(imageInputStream, this.lastRectangle);
                    }
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: {
                        switch (n2) {
                            case 80: 
                            case 88: {
                                this.context.frameOval(this.lastRectangle);
                                break;
                            }
                            case 81: 
                            case 89: {
                                this.context.paintOval(this.lastRectangle);
                                break;
                            }
                            case 82: 
                            case 90: {
                                this.context.eraseOval(this.lastRectangle);
                                break;
                            }
                            case 83: 
                            case 91: {
                                this.context.invertOval(this.lastRectangle);
                                break;
                            }
                            case 84: 
                            case 92: {
                                this.context.fillOval(this.lastRectangle, pattern);
                            }
                        }
                        if (!DEBUG) continue block196;
                        switch (n2) {
                            case 80: {
                                System.out.println("frameOval: " + this.lastRectangle);
                                break;
                            }
                            case 81: {
                                System.out.println("paintOval: " + this.lastRectangle);
                                break;
                            }
                            case 82: {
                                System.out.println("eraseOval: " + this.lastRectangle);
                                break;
                            }
                            case 83: {
                                System.out.println("invertOval: " + this.lastRectangle);
                                break;
                            }
                            case 84: {
                                System.out.println("fillOval: " + this.lastRectangle);
                                break;
                            }
                            case 88: {
                                System.out.println("frameSameOval: " + this.lastRectangle);
                                break;
                            }
                            case 89: {
                                System.out.println("paintSameOval: " + this.lastRectangle);
                                break;
                            }
                            case 90: {
                                System.out.println("eraseSameOval: " + this.lastRectangle);
                                break;
                            }
                            case 91: {
                                System.out.println("invertSameOval: " + this.lastRectangle);
                                break;
                            }
                            case 92: {
                                System.out.println("fillSameOval: " + this.lastRectangle);
                            }
                        }
                        continue block196;
                    }
                    case 53: 
                    case 54: 
                    case 55: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 85: 
                    case 86: 
                    case 87: {
                        imageInputStream.readFully(new byte[8], 0, 8);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: {
                        this.readRectangle(imageInputStream, this.lastRectangle);
                    }
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: {
                        int n5 = imageInputStream.readUnsignedShort();
                        int n4 = imageInputStream.readUnsignedShort();
                        point2.setLocation(n5, n4);
                        switch (n2) {
                            case 96: 
                            case 104: {
                                this.context.frameArc(this.lastRectangle, point2.x, point2.y);
                                break;
                            }
                            case 97: 
                            case 105: {
                                this.context.paintArc(this.lastRectangle, point2.x, point2.y);
                                break;
                            }
                            case 98: 
                            case 106: {
                                this.context.eraseArc(this.lastRectangle, point2.x, point2.y);
                                break;
                            }
                            case 99: 
                            case 107: {
                                this.context.invertArc(this.lastRectangle, point2.x, point2.y);
                                break;
                            }
                            case 100: 
                            case 108: {
                                this.context.fillArc(this.lastRectangle, point2.x, point2.y, pattern);
                            }
                        }
                        if (!DEBUG) continue block196;
                        switch (n2) {
                            case 96: {
                                System.out.println("frameArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 97: {
                                System.out.println("paintArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 98: {
                                System.out.println("eraseArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 99: {
                                System.out.println("invertArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 100: {
                                System.out.println("fillArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 104: {
                                System.out.println("frameSameArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 105: {
                                System.out.println("paintSameArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 106: {
                                System.out.println("eraseSameArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 107: {
                                System.out.println("invertSameArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 108: {
                                System.out.println("fillSameArc: " + this.lastRectangle + ", angles:" + point2);
                            }
                        }
                        continue block196;
                    }
                    case 101: 
                    case 102: 
                    case 103: {
                        imageInputStream.readFully(new byte[12], 0, 12);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 109: 
                    case 110: 
                    case 111: {
                        imageInputStream.readFully(new byte[4], 0, 4);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: {
                        polygon = this.readPoly(imageInputStream, rectangle);
                    }
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: {
                        switch (n2) {
                            case 112: 
                            case 120: {
                                this.context.framePoly(polygon);
                                break;
                            }
                            case 113: 
                            case 121: {
                                this.context.paintPoly(polygon);
                                break;
                            }
                            case 114: 
                            case 122: {
                                this.context.erasePoly(polygon);
                                break;
                            }
                            case 115: 
                            case 123: {
                                this.context.invertPoly(polygon);
                                break;
                            }
                            case 116: 
                            case 124: {
                                this.context.fillPoly(polygon, pattern);
                            }
                        }
                        if (!DEBUG) continue block196;
                        switch (n2) {
                            case 112: {
                                this.verbosePolyCmd("framePoly", rectangle, polygon);
                                break;
                            }
                            case 113: {
                                this.verbosePolyCmd("paintPoly", rectangle, polygon);
                                break;
                            }
                            case 114: {
                                this.verbosePolyCmd("erasePoly", rectangle, polygon);
                                break;
                            }
                            case 115: {
                                this.verbosePolyCmd("invertPoly", rectangle, polygon);
                                break;
                            }
                            case 116: {
                                this.verbosePolyCmd("fillPoly", rectangle, polygon);
                                break;
                            }
                            case 120: {
                                this.verbosePolyCmd("frameSamePoly", rectangle, polygon);
                                break;
                            }
                            case 121: {
                                this.verbosePolyCmd("paintSamePoly", rectangle, polygon);
                                break;
                            }
                            case 122: {
                                this.verbosePolyCmd("eraseSamePoly", rectangle, polygon);
                                break;
                            }
                            case 123: {
                                this.verbosePolyCmd("invertSamePoly", rectangle, polygon);
                                break;
                            }
                            case 124: {
                                this.verbosePolyCmd("fillSamePoly", rectangle, polygon);
                            }
                        }
                        continue block196;
                    }
                    case 117: 
                    case 118: 
                    case 119: {
                        polygon = this.readPoly(imageInputStream, rectangle);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: {
                        polygon2 = this.readRegion(imageInputStream, rectangle);
                    }
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: {
                        if (polygon2 != null && polygon2.npoints > 1) {
                            switch (n2) {
                                case 128: 
                                case 136: {
                                    this.context.frameRegion(new Area(polygon2));
                                    break;
                                }
                                case 129: 
                                case 137: {
                                    this.context.paintRegion(new Area(polygon2));
                                    break;
                                }
                                case 130: 
                                case 138: {
                                    this.context.eraseRegion(new Area(polygon2));
                                    break;
                                }
                                case 131: 
                                case 139: {
                                    this.context.invertRegion(new Area(polygon2));
                                    break;
                                }
                                case 132: 
                                case 140: {
                                    this.context.fillRegion(new Area(polygon2), pattern);
                                }
                            }
                        }
                        if (!DEBUG) continue block196;
                        switch (n2) {
                            case 128: {
                                this.verboseRegionCmd("frameRgn", rectangle, polygon2);
                                break;
                            }
                            case 129: {
                                this.verboseRegionCmd("paintRgn", rectangle, polygon2);
                                break;
                            }
                            case 130: {
                                this.verboseRegionCmd("eraseRgn", rectangle, polygon2);
                                break;
                            }
                            case 131: {
                                this.verboseRegionCmd("invertRgn", rectangle, polygon2);
                                break;
                            }
                            case 132: {
                                this.verboseRegionCmd("fillRgn", rectangle, polygon2);
                                break;
                            }
                            case 136: {
                                this.verboseRegionCmd("frameSameRgn", rectangle, polygon2);
                                break;
                            }
                            case 137: {
                                this.verboseRegionCmd("paintSameRgn", rectangle, polygon2);
                                break;
                            }
                            case 138: {
                                this.verboseRegionCmd("eraseSameRgn", rectangle, polygon2);
                                break;
                            }
                            case 139: {
                                this.verboseRegionCmd("invertSameRgn", rectangle, polygon2);
                                break;
                            }
                            case 140: {
                                this.verboseRegionCmd("fillSameRgn", rectangle, polygon2);
                            }
                        }
                        continue block196;
                    }
                    case 133: 
                    case 134: 
                    case 135: {
                        polygon2 = this.readRegion(imageInputStream, rectangle);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 144: {
                        int n10 = imageInputStream.readUnsignedShort();
                        int n11 = n10 & 0x3FFF;
                        if ((n10 & 0x8000) > 0) {
                            // empty if block
                        }
                        rectangle = new Rectangle();
                        int n4 = imageInputStream.readUnsignedShort();
                        int n5 = imageInputStream.readUnsignedShort();
                        rectangle.setLocation(n5, n4);
                        n4 = imageInputStream.readUnsignedShort();
                        n5 = imageInputStream.readUnsignedShort();
                        rectangle.setSize(n5 - rectangle.x, n4 - rectangle.y);
                        Rectangle rectangle2 = new Rectangle();
                        this.readRectangle(imageInputStream, rectangle2);
                        Rectangle rectangle3 = new Rectangle();
                        this.readRectangle(imageInputStream, rectangle3);
                        int n3 = imageInputStream.readUnsignedShort();
                        this.context.setPenMode(n3);
                        if (DEBUG) {
                            System.out.print("bitsRect, rowBytes: " + n11);
                            if ((n10 & 0x8000) > 0) {
                                System.out.print(", it is a PixMap");
                            } else {
                                System.out.print(", it is a BitMap");
                            }
                            System.out.print(", bounds: " + rectangle);
                            System.out.print(", srcRect: " + rectangle2);
                            System.out.print(", dstRect: " + rectangle3);
                            System.out.print(", mode: " + n3);
                            System.out.println();
                        }
                        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 12);
                        byte[] byArray3 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                        int n12 = rectangle.width / 8;
                        for (int i = 0; i < rectangle.height; ++i) {
                            imageInputStream.readFully(byArray3, i * n12, n12);
                            imageInputStream.skipBytes(n11 - n12);
                        }
                        Rectangle rectangle4 = new Rectangle(rectangle2);
                        rectangle4.translate(-rectangle.x, -rectangle.y);
                        this.context.copyBits(bufferedImage, rectangle4, rectangle3, n3, null);
                        break;
                    }
                    case 145: {
                        if (!DEBUG) continue block196;
                        System.out.println("bitsRgn");
                        break;
                    }
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: {
                        int n7 = imageInputStream.readUnsignedShort();
                        imageInputStream.readFully(new byte[n7], 0, n7);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 152: {
                        this.readOpPackBitsRect(imageInputStream, rectangle, n++);
                        if (!DEBUG) continue block196;
                        System.out.println("packBitsRect - TODO");
                        break;
                    }
                    case 153: {
                        if (!DEBUG) continue block196;
                        System.out.println("packBitsRgn - TODO");
                        break;
                    }
                    case 154: {
                        this.readOpDirectBitsRect(imageInputStream, rectangle, n++);
                        break;
                    }
                    case 155: {
                        if (!DEBUG) continue block196;
                        System.out.println("directBitsRgn - TODO");
                        break;
                    }
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: {
                        int n7 = imageInputStream.readUnsignedShort();
                        imageInputStream.readFully(new byte[n7], 0, n7);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 160: {
                        imageInputStream.readFully(new byte[2], 0, 2);
                        if (!DEBUG) continue block196;
                        System.out.println("Short comment");
                        break;
                    }
                    case 161: {
                        this.readLongComment(imageInputStream);
                        if (!DEBUG) continue block196;
                        System.out.println("Long comment");
                        break;
                    }
                    case 255: {
                        break;
                    }
                    case 33280: {
                        if (DEBUG) {
                            System.out.println("compressedQuickTime");
                        }
                        this.readCompressedQT(imageInputStream);
                        break;
                    }
                    case 33281: {
                        int n7 = imageInputStream.readInt();
                        imageInputStream.readFully(new byte[n7], 0, n7);
                        if (!DEBUG) continue block196;
                        System.out.println("unCompressedQuickTime");
                        break;
                    }
                    case 65535: {
                        int n7 = imageInputStream.readInt();
                        imageInputStream.readFully(new byte[n7], 0, n7);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x - length: %s", "Reserved for Apple use.", n2, n7));
                        break;
                    }
                    default: {
                        int n7;
                        if (n2 >= 160 && n2 <= 175) {
                            n7 = imageInputStream.readUnsignedShort();
                            imageInputStream.readFully(new byte[n7], 0, n7);
                        } else if (n2 >= 176 && n2 <= 207) {
                            n7 = 0;
                        } else if (n2 >= 208 && n2 <= 254) {
                            n7 = imageInputStream.readInt();
                            imageInputStream.readFully(new byte[n7], 0, n7);
                        } else if (n2 >= 256 && n2 <= Short.MAX_VALUE) {
                            n7 = ((n2 & 0xFF00) >> 8) * 2;
                            imageInputStream.skipBytes(n7);
                        } else if (n2 >= 32768 && n2 <= 33023) {
                            n7 = 0;
                        } else if (n2 >= 33024 && n2 <= 33279) {
                            n7 = imageInputStream.readInt();
                            imageInputStream.readFully(new byte[n7], 0, n7);
                        } else {
                            throw new IIOException(String.format("Found unknown opcode: 0x%04x", n2));
                        }
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x - length: %s", "Reserved for Apple use.", n2, n7));
                    }
                }
            } while (n2 != 255);
        }
        catch (IIOException iIOException) {
            throw iIOException;
        }
        catch (EOFException eOFException) {
            String string;
            try {
                string = String.format("position %d", this.imageInput.getStreamPosition());
            }
            catch (IOException iOException) {
                string = "unknown position";
            }
            throw new IIOException(String.format("Error in PICT format: Unexpected end of File at %s", string), eOFException);
        }
        catch (IOException iOException) {
            throw new IIOException(String.format("Error in PICT format: %s", iOException.getMessage()), iOException);
        }
    }

    private void readCompressedQT(ImageInputStream imageInputStream) throws IOException {
        int n;
        int n2;
        int n3 = imageInputStream.readInt();
        long l = imageInputStream.getStreamPosition();
        if (DEBUG) {
            System.out.println("QT data length: " + n3);
        }
        for (int i = 0; i < 13; ++i) {
            n2 = imageInputStream.readInt();
            if (!DEBUG) continue;
            System.out.println(String.format("%2d: 0x%08x", i * 4, n2));
        }
        Rectangle rectangle = new Rectangle();
        this.readRectangle(imageInputStream, rectangle);
        if (DEBUG) {
            System.out.println("...");
        }
        for (n2 = 0; n2 < 2; ++n2) {
            n = imageInputStream.readInt();
            if (!DEBUG) continue;
            System.out.println(String.format("%2d: 0x%08x", (n2 + 15) * 4, n));
        }
        BufferedImage bufferedImage = QuickTime.decompress(imageInputStream);
        if (bufferedImage != null) {
            this.context.copyBits(bufferedImage, new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight()), rectangle, 0, null);
            imageInputStream.seek(l + (long)n3);
            n = imageInputStream.readInt();
            if (n == 458926) {
                int n4 = imageInputStream.readUnsignedShort();
                imageInputStream.skipBytes(n4);
            } else {
                imageInputStream.seek(l + (long)n3);
            }
        } else {
            imageInputStream.seek(l + (long)n3);
        }
    }

    private void readOpPackBitsRect(ImageInputStream imageInputStream, Rectangle rectangle, int n) throws IOException {
        BufferedImage bufferedImage;
        Object object;
        Object object2;
        if (DEBUG) {
            System.out.println("packBitsRect");
        }
        int n2 = imageInputStream.readUnsignedShort();
        int n3 = n2 & 0x3FFF;
        if (DEBUG) {
            System.out.print("packBitsRect, rowBytes: " + n3);
            if ((n2 & 0x8000) > 0) {
                System.out.print(", it is a PixMap");
            } else {
                System.out.print(", it is a BitMap");
            }
        }
        int n4 = imageInputStream.readUnsignedShort();
        int n5 = imageInputStream.readUnsignedShort();
        rectangle.setLocation(n5, n4);
        n4 = imageInputStream.readUnsignedShort();
        n5 = imageInputStream.readUnsignedShort();
        rectangle.setSize(n5 - rectangle.x, n4 - rectangle.y);
        if (DEBUG) {
            System.out.print(", bounds: " + rectangle);
        }
        int n6 = imageInputStream.readUnsignedShort() & 0xFFFF;
        if (DEBUG) {
            System.out.print(", pmVersion: " + n6);
        }
        int n7 = imageInputStream.readUnsignedShort() & 0xFFFF;
        if (DEBUG) {
            System.out.print(", packType: " + n7);
        }
        int n8 = imageInputStream.readInt();
        if (DEBUG) {
            System.out.println(", packSize: " + n8);
        }
        double d = PICTUtil.readFixedPoint(imageInputStream);
        double d2 = PICTUtil.readFixedPoint(imageInputStream);
        if (DEBUG) {
            System.out.print("hRes: " + d + ", vRes: " + d2);
        }
        int n9 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            if (n9 == 0) {
                System.out.print(", indexed pixels");
            } else {
                System.out.print(", RGBDirect");
            }
        }
        int n10 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print(", pixelSize:" + n10);
        }
        int n11 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print(", cmpCount:" + n11);
        }
        int n12 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print(", cmpSize:" + n12);
        }
        int n13 = imageInputStream.readInt();
        if (DEBUG) {
            System.out.print(", planeBytes:" + n13);
        }
        int n14 = imageInputStream.readInt();
        if (DEBUG) {
            System.out.println(", clutId:" + n14);
        }
        imageInputStream.readInt();
        if (n9 != 0) {
            throw new IIOException("Unsupported pixel type: " + n9);
        }
        IndexColorModel indexColorModel = PICTUtil.readColorTable(imageInputStream, n10);
        Rectangle rectangle2 = new Rectangle();
        n4 = imageInputStream.readUnsignedShort();
        n5 = imageInputStream.readUnsignedShort();
        rectangle2.setLocation(n5, n4);
        n4 = imageInputStream.readUnsignedShort();
        n5 = imageInputStream.readUnsignedShort();
        rectangle2.setSize(n5 - rectangle2.x, n4 - rectangle2.y);
        if (DEBUG) {
            System.out.print("opPackBitsRect, srcRect:" + rectangle2);
        }
        Rectangle rectangle3 = new Rectangle();
        this.readRectangle(imageInputStream, rectangle3);
        if (DEBUG) {
            System.out.print(", dstRect:" + rectangle3);
        }
        int n15 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print(", mode: " + n15);
        }
        if (n7 != 0) {
            throw new IIOException("Unknown pack type: " + n7);
        }
        byte[] byArray = new byte[n11 * rectangle.width];
        byte[] byArray2 = new byte[rectangle.height * rectangle.width];
        int n16 = 0;
        for (int i = 0; i < rectangle.height; ++i) {
            int n17 = n3 > 250 ? imageInputStream.readUnsignedShort() : imageInputStream.readUnsignedByte();
            if (DEBUG) {
                System.out.println();
                System.out.print("Line " + i + ", byteCount: " + n17);
                System.out.print(" dstBytes: " + byArray.length);
            }
            object2 = new PackBitsDecoder();
            object = new DataInputStream((InputStream)new DecoderStream(IIOUtil.createStreamAdapter((ImageInputStream)imageInputStream, (long)n17), (Decoder)object2));
            object.readFully(byArray2, n16, rectangle.width);
            n16 += rectangle.width;
            this.processImageProgress(i * 100 / rectangle.height);
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            for (int j = i + 1; j < rectangle.height; ++j) {
                n17 = n3 > 250 ? imageInputStream.readUnsignedShort() : imageInputStream.readUnsignedByte();
                imageInputStream.readFully(new byte[n17], 0, n17);
                if (!DEBUG) continue;
                System.out.println();
                System.out.print("Skip " + j + ", byteCount: " + n17);
            }
            break;
        }
        if (this.images.size() <= n) {
            DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
            object2 = Raster.createPackedRaster(dataBufferByte, rectangle.width, rectangle.height, n12, null);
            object = new BufferedImage(indexColorModel, (WritableRaster)object2, indexColorModel.isAlphaPremultiplied(), null);
            this.images.add((BufferedImage)object);
        }
        if ((bufferedImage = this.images.get(n)) != null) {
            rectangle2.setLocation(0, 0);
            this.context.copyBits(bufferedImage, rectangle2, rectangle3, n15, null);
        }
        if (DEBUG) {
            System.out.println();
        }
    }

    private void readOpDirectBitsRect(ImageInputStream imageInputStream, Rectangle rectangle, int n) throws IOException {
        BufferedImage bufferedImage;
        Object object;
        byte[] byArray;
        if (DEBUG) {
            System.out.println("directBitsRect");
        }
        imageInputStream.skipBytes(4);
        int n2 = imageInputStream.readUnsignedShort();
        int n3 = n2 & 0x3FFF;
        if (DEBUG) {
            System.out.print("directBitsRect, rowBytes: " + n3);
            if ((n2 & 0x8000) > 0) {
                System.out.print(", it is a PixMap");
            } else {
                System.out.print(", it is a BitMap");
            }
        }
        int n4 = imageInputStream.readUnsignedShort();
        int n5 = imageInputStream.readUnsignedShort();
        rectangle.setLocation(n5, n4);
        n4 = imageInputStream.readUnsignedShort();
        n5 = imageInputStream.readUnsignedShort();
        rectangle.setSize(n5 - rectangle.x, n4 - rectangle.y);
        if (DEBUG) {
            System.out.print(", bounds: " + rectangle);
        }
        int n6 = imageInputStream.readUnsignedShort() & 0xFFFF;
        if (DEBUG) {
            System.out.print(", pmVersion: " + n6);
        }
        int n7 = imageInputStream.readUnsignedShort() & 0xFFFF;
        if (DEBUG) {
            System.out.print(", packType: " + n7);
        }
        int n8 = imageInputStream.readInt();
        if (DEBUG) {
            System.out.println(", packSize: " + n8);
        }
        double d = PICTUtil.readFixedPoint(imageInputStream);
        double d2 = PICTUtil.readFixedPoint(imageInputStream);
        if (DEBUG) {
            System.out.print("hRes: " + d + ", vRes: " + d2);
        }
        int n9 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            if (n9 == 0) {
                System.out.print(", indexed pixels");
            } else {
                System.out.print(", RGBDirect");
            }
        }
        int n10 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print(", pixelSize:" + n10);
        }
        int n11 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print(", cmpCount:" + n11);
        }
        int n12 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.println(", cmpSize:" + n12);
        }
        imageInputStream.readInt();
        imageInputStream.readInt();
        imageInputStream.readInt();
        Rectangle rectangle2 = new Rectangle();
        n4 = imageInputStream.readUnsignedShort();
        n5 = imageInputStream.readUnsignedShort();
        rectangle2.setLocation(n5, n4);
        n4 = imageInputStream.readUnsignedShort();
        n5 = imageInputStream.readUnsignedShort();
        rectangle2.setSize(n5 - rectangle2.x, n4 - rectangle2.y);
        if (DEBUG) {
            System.out.print("opDirectBitsRect, srcRect:" + rectangle2);
        }
        Rectangle rectangle3 = new Rectangle();
        this.readRectangle(imageInputStream, rectangle3);
        if (DEBUG) {
            System.out.print(", dstRect:" + rectangle3);
        }
        int n13 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print(", mode: " + n13);
        }
        if (n7 == 1 || n3 < 8) {
            byArray = new byte[n3];
        } else if (n7 == 2) {
            byArray = new byte[n3 * 3 / 4];
        } else if (n7 == 3) {
            byArray = new byte[2 * rectangle.width];
        } else if (n7 == 4) {
            byArray = new byte[n11 * rectangle.width];
        } else {
            throw new IIOException("Unknown pack type: " + n7);
        }
        int[] nArray = null;
        short[] sArray = null;
        if (n7 == 3) {
            sArray = new short[rectangle.height * rectangle.width];
        } else {
            nArray = new int[rectangle.height * rectangle.width];
        }
        int n14 = 0;
        for (int i = 0; i < rectangle.height; ++i) {
            int n15;
            int n16 = n3 > 250 ? imageInputStream.readUnsignedShort() : imageInputStream.readUnsignedByte();
            if (DEBUG) {
                System.out.println();
                System.out.print("Line " + i + ", byteCount: " + n16);
                System.out.print(" dstBytes: " + byArray.length);
            }
            if (n7 > 2) {
                Object object2 = n7 == 3 ? new PackBits16Decoder() : new PackBitsDecoder();
                object = new DataInputStream((InputStream)new DecoderStream(IIOUtil.createStreamAdapter((ImageInputStream)imageInputStream, (long)n16), (Decoder)object2));
                object.readFully(byArray);
            } else {
                this.imageInput.readFully(byArray);
            }
            if (n7 == 3) {
                for (n15 = 0; n15 < rectangle.width; ++n15) {
                    sArray[n14 + n15] = (short)((0xFF & byArray[2 * n15]) << 8 | 0xFF & byArray[2 * n15 + 1]);
                }
            } else if (n11 == 3) {
                for (n15 = 0; n15 < rectangle.width; ++n15) {
                    nArray[n14 + n15] = -16777216;
                    int n17 = n14 + n15;
                    nArray[n17] = nArray[n17] | (byArray[n15] & 0xFF) << 16;
                    int n18 = n14 + n15;
                    nArray[n18] = nArray[n18] | (byArray[rectangle.width + n15] & 0xFF) << 8;
                    int n19 = n14 + n15;
                    nArray[n19] = nArray[n19] | byArray[2 * rectangle.width + n15] & 0xFF;
                }
            } else {
                for (n15 = 0; n15 < rectangle.width; ++n15) {
                    nArray[n14 + n15] = (byArray[n15] & 0xFF) << 24;
                    int n20 = n14 + n15;
                    nArray[n20] = nArray[n20] | (byArray[rectangle.width + n15] & 0xFF) << 16;
                    int n21 = n14 + n15;
                    nArray[n21] = nArray[n21] | (byArray[2 * rectangle.width + n15] & 0xFF) << 8;
                    int n22 = n14 + n15;
                    nArray[n22] = nArray[n22] | byArray[3 * rectangle.width + n15] & 0xFF;
                }
            }
            n14 += rectangle.width;
            this.processImageProgress(i * 100 / rectangle.height);
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            for (n15 = i + 1; n15 < rectangle.height; ++n15) {
                n16 = n3 > 250 ? imageInputStream.readUnsignedShort() : imageInputStream.readUnsignedByte();
                imageInputStream.readFully(new byte[n16], 0, n16);
                if (!DEBUG) continue;
                System.out.println();
                System.out.print("Skip " + n15 + ", byteCount: " + n16);
            }
            break;
        }
        if (this.images.size() <= n) {
            WritableRaster writableRaster;
            DirectColorModel directColorModel;
            if (n7 == 3) {
                directColorModel = new DirectColorModel(15, 31744, 992, 31);
                object = new DataBufferUShort(sArray, sArray.length);
                writableRaster = Raster.createPackedRaster((DataBuffer)object, rectangle.width, rectangle.height, rectangle.width, directColorModel.getMasks(), null);
            } else {
                directColorModel = (DirectColorModel)ColorModel.getRGBdefault();
                object = new DataBufferInt(nArray, nArray.length);
                writableRaster = Raster.createPackedRaster((DataBuffer)object, rectangle.width, rectangle.height, rectangle.width, directColorModel.getMasks(), null);
            }
            object = new BufferedImage(directColorModel, writableRaster, directColorModel.isAlphaPremultiplied(), null);
            this.images.add((BufferedImage)object);
        }
        if ((bufferedImage = this.images.get(n)) != null) {
            rectangle2.setLocation(0, 0);
            this.context.copyBits(bufferedImage, rectangle2, rectangle3, n13, null);
        }
        if (DEBUG) {
            System.out.println();
        }
    }

    private void readRectangle(DataInput dataInput, Rectangle rectangle) throws IOException {
        int n = dataInput.readUnsignedShort();
        int n2 = dataInput.readUnsignedShort();
        int n3 = dataInput.readUnsignedShort();
        int n4 = dataInput.readUnsignedShort();
        rectangle.setLocation(this.getXPtCoord(n2), this.getYPtCoord(n));
        rectangle.setSize(this.getXPtCoord(n4 - n2), this.getYPtCoord(n3 - n));
    }

    private Polygon readRegion(DataInput dataInput, Rectangle rectangle) throws IOException {
        int n = dataInput.readUnsignedShort();
        int n2 = this.getYPtCoord(dataInput.readUnsignedShort());
        int n3 = this.getXPtCoord(dataInput.readUnsignedShort());
        rectangle.setLocation(n3, n2);
        n2 = this.getYPtCoord(dataInput.readShort()) - rectangle.getLocation().y;
        n3 = this.getXPtCoord(dataInput.readShort()) - rectangle.getLocation().x;
        rectangle.setSize(n3, n2);
        int n4 = (n - 10) / 4;
        Polygon polygon = new Polygon();
        for (int i = 0; i < n4; ++i) {
            n3 = this.getXPtCoord(dataInput.readShort());
            n2 = this.getYPtCoord(dataInput.readShort());
            polygon.addPoint(n3, n2);
        }
        return polygon;
    }

    private Polygon readPoly(DataInput dataInput, Rectangle rectangle) throws IOException {
        int n = dataInput.readUnsignedShort();
        int n2 = this.getYPtCoord(dataInput.readShort());
        int n3 = this.getXPtCoord(dataInput.readShort());
        rectangle.setLocation(n3, n2);
        n2 = this.getYPtCoord(dataInput.readShort()) - rectangle.getLocation().y;
        n3 = this.getXPtCoord(dataInput.readShort()) - rectangle.getLocation().x;
        rectangle.setSize(n3, n2);
        int n4 = (n - 10) / 4;
        Polygon polygon = new Polygon();
        for (int i = 0; i < n4; ++i) {
            n2 = this.getYPtCoord(dataInput.readShort());
            n3 = this.getXPtCoord(dataInput.readShort());
            polygon.addPoint(n3, n2);
        }
        return polygon;
    }

    private void readLongComment(DataInput dataInput) throws IOException {
        dataInput.readShort();
        int n = dataInput.readUnsignedShort();
        dataInput.readFully(new byte[n], 0, n);
    }

    private int getXPtCoord(int n) {
        return (int)((double)n / this.screenImageXRatio);
    }

    private int getYPtCoord(int n) {
        return (int)((double)n / this.screenImageYRatio);
    }

    private void verbosePolyCmd(String string, Rectangle rectangle, Polygon polygon) {
        int n;
        System.out.println(string + ": " + new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        System.out.print("Polygon points: ");
        for (n = 0; polygon != null && n < polygon.npoints - 1; ++n) {
            System.out.print("(" + polygon.xpoints[n] + "," + polygon.ypoints[n] + "), ");
        }
        if (polygon != null && polygon.npoints > 0) {
            System.out.print("(" + polygon.xpoints[n] + "," + polygon.ypoints[n] + ")");
        }
        System.out.println();
    }

    private void verboseRegionCmd(String string, Rectangle rectangle, Polygon polygon) {
        int n;
        System.out.println(string + ": " + new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        System.out.print("Region points: ");
        for (n = 0; polygon != null && n < polygon.npoints - 1; ++n) {
            System.out.print("(" + polygon.xpoints[n] + "," + polygon.ypoints[n] + "), ");
        }
        if (polygon != null && polygon.npoints > 0) {
            System.out.print("(" + polygon.xpoints[n] + "," + polygon.ypoints[n] + ")");
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        int n2;
        int n3;
        this.checkBounds(n);
        this.processImageStarted(n);
        if (imageReadParam != null) {
            n3 = imageReadParam.getSourceXSubsampling();
            n2 = imageReadParam.getSourceYSubsampling();
        } else {
            n3 = 1;
            n2 = 1;
        }
        Rectangle rectangle = this.getPICTFrame();
        BufferedImage bufferedImage = PICTImageReader.getDestination((ImageReadParam)imageReadParam, this.getImageTypes(n), (int)this.getXPtCoord(rectangle.width), (int)this.getYPtCoord(rectangle.height));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            AffineTransform affineTransform = new AffineTransform();
            if (imageReadParam != null && imageReadParam.getSourceRegion() != null) {
                Rectangle rectangle2 = imageReadParam.getSourceRegion();
                affineTransform.translate(-rectangle2.x, -rectangle2.y);
            }
            affineTransform.scale(this.screenImageXRatio / (double)n3, this.screenImageYRatio / (double)n2);
            graphics2D.setTransform(affineTransform);
            this.drawOnto(graphics2D);
        }
        finally {
            graphics2D.dispose();
        }
        this.processImageComplete();
        return bufferedImage;
    }

    public int getWidth(int n) throws IOException {
        this.checkBounds(n);
        return this.getXPtCoord(this.getPICTFrame().width);
    }

    public int getHeight(int n) throws IOException {
        this.checkBounds(n);
        return this.getYPtCoord(this.getPICTFrame().height);
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        return Arrays.asList(ImageTypeSpecifier.createPacked(ColorSpace.getInstance(1000), 0xFF0000, 65280, 255, -16777216, 3, false)).iterator();
    }

    public static void main(String[] stringArray) throws IOException {
        String string;
        ImageInputStream imageInputStream;
        PICTImageReader pICTImageReader = new PICTImageReader(new PICTImageReaderSpi());
        if (stringArray.length >= 1) {
            File file = new File(stringArray[0]);
            imageInputStream = ImageIO.createImageInputStream(file);
            string = file.getName();
        } else {
            imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(DATA_V1_OVERPAINTED_ARC));
            string = "PICT test data";
        }
        System.out.println("canRead: " + ((ImageReader)((Object)pICTImageReader)).getOriginatingProvider().canDecodeInput(imageInputStream));
        ((ImageReader)((Object)pICTImageReader)).setInput(imageInputStream);
        long l = System.currentTimeMillis();
        BufferedImage bufferedImage = ((ImageReader)((Object)pICTImageReader)).read(0);
        System.out.println("time: " + (System.currentTimeMillis() - l));
        PICTImageReader.showIt((BufferedImage)bufferedImage, (String)string);
        System.out.println("image = " + bufferedImage);
    }
}

