/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.fonts.spi;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import java.util.HashSet;

public abstract class FontResolver {
    private static HashMap knownFontsMap;
    private static HashSet availableFonts;

    protected boolean systemHasFont(String fontName) {
        return availableFonts.contains(fontName);
    }

    protected String getLogicalFont(String fontName) {
        return (String)knownFontsMap.get(fontName);
    }

    public abstract Font resolveFont(String var1, int var2, int var3);

    static {
        availableFonts = new HashSet();
        String[] systemFontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int x = 0; x < systemFontNames.length; ++x) {
            availableFonts.add(systemFontNames[x]);
        }
        knownFontsMap = new HashMap();
        knownFontsMap.put("Aldus", "Serif");
        knownFontsMap.put("Antiqua", "Serif");
        knownFontsMap.put("Baskerville", "Serif");
        knownFontsMap.put("Bell", "Serif");
        knownFontsMap.put("Bembo", "Serif");
        knownFontsMap.put("Benguiat", "Serif");
        knownFontsMap.put("Bulmer", "Serif");
        knownFontsMap.put("Bodoni", "Serif");
        knownFontsMap.put("Bauer Bodoni", "Serif");
        knownFontsMap.put("Bookman", "Serif");
        knownFontsMap.put("Cambria", "Serif");
        knownFontsMap.put("Caledonia", "Serif");
        knownFontsMap.put("Calisto", "Serif");
        knownFontsMap.put("Caslon", "Serif");
        knownFontsMap.put("Centaur", "Serif");
        knownFontsMap.put("Century Schoolbook", "Serif");
        knownFontsMap.put("Cheltenham", "Serif");
        knownFontsMap.put("Clarendon", "Serif");
        knownFontsMap.put("Computer Modern", "Serif");
        knownFontsMap.put("Constantia", "Serif");
        knownFontsMap.put("DejaVu Serif", "Serif");
        knownFontsMap.put("Garamond", "Serif");
        knownFontsMap.put("Gentium", "Serif");
        knownFontsMap.put("Georgia", "Serif");
        knownFontsMap.put("Goudy Old Style", "Serif");
        knownFontsMap.put("Granjon", "Serif");
        knownFontsMap.put("Hoefler Text", "Serif");
        knownFontsMap.put("Janson", "Serif");
        knownFontsMap.put("Jenson", "Serif");
        knownFontsMap.put("Libertine", "Serif");
        knownFontsMap.put("Literaturnaya", "Serif");
        knownFontsMap.put("Lucida Bright", "Serif");
        knownFontsMap.put("Minion", "Serif");
        knownFontsMap.put("Palatino", "Serif");
        knownFontsMap.put("Palatino Linotype", "Serif");
        knownFontsMap.put("Perpetua", "Serif");
        knownFontsMap.put("Rawlinson Roadway", "Serif");
        knownFontsMap.put("Requiem", "Serif");
        knownFontsMap.put("Rockwell", "Serif");
        knownFontsMap.put("Rotis", "Serif");
        knownFontsMap.put("Sabon", "Serif");
        knownFontsMap.put("Times New Roman", "Serif");
        knownFontsMap.put("Agency FB", "SansSerif");
        knownFontsMap.put("Akzidenz Grotesk", "SansSerif");
        knownFontsMap.put("Arial", "SansSerif");
        knownFontsMap.put("Arial Unicode MS", "SansSerif");
        knownFontsMap.put("Arial Black", "SansSerif");
        knownFontsMap.put("Avant Garde Gothic", "SansSerif");
        knownFontsMap.put("Avenir", "SansSerif");
        knownFontsMap.put("Bank Gothic", "SansSerif");
        knownFontsMap.put("Bell Centennial", "SansSerif");
        knownFontsMap.put("Bell Gothic", "SansSerif");
        knownFontsMap.put("Benguiat Gothic", "SansSerif");
        knownFontsMap.put("Cafeteria", "SansSerif");
        knownFontsMap.put("Calibri", "SansSerif");
        knownFontsMap.put("Century Gothic", "SansSerif");
        knownFontsMap.put("Charcoal", "SansSerif");
        knownFontsMap.put("Chicago", "SansSerif");
        knownFontsMap.put("Clearface Gothic", "SansSerif");
        knownFontsMap.put("Clearview", "SansSerif");
        knownFontsMap.put("Co Headline", "SansSerif");
        knownFontsMap.put("Co Text", "SansSerif");
        knownFontsMap.put("Comic Sans", "SansSerif");
        knownFontsMap.put("Corbel", "SansSerif");
        knownFontsMap.put("DejaVu Sans", "SansSerif");
        knownFontsMap.put("Eras", "SansSerif");
        knownFontsMap.put("Espy Sans", "SansSerif");
        knownFontsMap.put("Nu Sans", "SansSerif");
        knownFontsMap.put("Eurocrat", "SansSerif");
        knownFontsMap.put("Eurostile", "SansSerif");
        knownFontsMap.put("Formata BQ", "SansSerif");
        knownFontsMap.put("FreeSans", "SansSerif");
        knownFontsMap.put("Franklin Gothic", "SansSerif");
        knownFontsMap.put("Frutiger", "SansSerif");
        knownFontsMap.put("Fritiger NEXT", "SansSerif");
        knownFontsMap.put("Futura", "SansSerif");
        knownFontsMap.put("Geneva", "SansSerif");
        knownFontsMap.put("Gill Sans", "SansSerif");
        knownFontsMap.put("Gill Sans Schoolbook", "SansSerif");
        knownFontsMap.put("Handel Gothic", "SansSerif");
        knownFontsMap.put("Denmark", "SansSerif");
        knownFontsMap.put("Haettenschweiler", "SansSerif");
        knownFontsMap.put("Helvetica", "SansSerif");
        knownFontsMap.put("Helvetica Neue", "SansSerif");
        knownFontsMap.put("Swiss 721", "SansSerif");
        knownFontsMap.put("Highway Gothic", "SansSerif");
        knownFontsMap.put("Hiroshige Sans", "SansSerif");
        knownFontsMap.put("Hobo", "SansSerif");
        knownFontsMap.put("Impact", "SansSerif");
        knownFontsMap.put("Industria Solid", "SansSerif");
        knownFontsMap.put("Johnston", "SansSerif");
        knownFontsMap.put("New Johnston", "SansSerif");
        knownFontsMap.put("Kabel", "SansSerif");
        knownFontsMap.put("Legacy Sans", "SansSerif");
        knownFontsMap.put("Lucida Sans", "SansSerif");
        knownFontsMap.put("Lucida Sans Unicode", "SansSerif");
        knownFontsMap.put("Lucida Grande", "SansSerif");
        knownFontsMap.put("Microgramma", "SansSerif");
        knownFontsMap.put("Modern", "SansSerif");
        knownFontsMap.put("MS Sans Serif", "SansSerif");
        knownFontsMap.put("Myriad", "SansSerif");
        knownFontsMap.put("News Gothic", "SansSerif");
        knownFontsMap.put("Optima", "SansSerif");
        knownFontsMap.put("Prima Sans", "SansSerif");
        knownFontsMap.put("Rail Alphabet", "SansSerif");
        knownFontsMap.put("Revue", "SansSerif");
        knownFontsMap.put("Rotis Sans", "SansSerif");
        knownFontsMap.put("Segoe UI", "SansSerif");
        knownFontsMap.put("Skia", "SansSerif");
        knownFontsMap.put("Souvenir Gothic", "SansSerif");
        knownFontsMap.put("Stone Sans", "SansSerif");
        knownFontsMap.put("Tahoma", "SansSerif");
        knownFontsMap.put("Tiresias", "SansSerif");
        knownFontsMap.put("Trade Gothic", "SansSerif");
        knownFontsMap.put("Transport alphabet", "SansSerif");
        knownFontsMap.put("Trebuchet", "SansSerif");
        knownFontsMap.put("Twentieth Century", "SansSerif");
        knownFontsMap.put("Univers", "SansSerif");
        knownFontsMap.put("Vera Sans", "SansSerif");
        knownFontsMap.put("Verdana", "SansSerif");
        knownFontsMap.put("Akkurat Mono", "Monospaced");
        knownFontsMap.put("Andale Mono", "Monospaced");
        knownFontsMap.put("Arial Monospaced", "Monospaced");
        knownFontsMap.put("Vera Sans Mono", "Monospaced");
        knownFontsMap.put("Botanika Mono", "Monospaced");
        knownFontsMap.put("Consolas", "Monospaced");
        knownFontsMap.put("Courier", "Monospaced");
        knownFontsMap.put("Courier New", "Monospaced");
        knownFontsMap.put("CourierHP", "Monospaced");
        knownFontsMap.put("Fontcraft Courier", "Monospaced");
        knownFontsMap.put("DejaVu Sans Mono", "Monospaced");
        knownFontsMap.put("FF Elementa", "Monospaced");
        knownFontsMap.put("Etelka Monospace", "Monospaced");
        knownFontsMap.put("FF Eureka Mono", "Monospaced");
        knownFontsMap.put("Everson Mono", "Monospaced");
        knownFontsMap.put("Everson Mono Unicode", "Monospaced");
        knownFontsMap.put("Fedra Mono", "Monospaced");
        knownFontsMap.put("Fixed", "Monospaced");
        knownFontsMap.put("Fixedsys", "Monospaced");
        knownFontsMap.put("Fixedsys Excelsior", "Monospaced");
        knownFontsMap.put("FreeMono", "Monospaced");
        knownFontsMap.put("Free Monospaced", "Monospaced");
        knownFontsMap.put("Helvetica Mono", "Monospaced");
        knownFontsMap.put("Hyperfont", "Monospaced");
        knownFontsMap.put("Isonorm", "Monospaced");
        knownFontsMap.put("Inconsolata", "Monospaced");
        knownFontsMap.put("Letter Gothic", "Monospaced");
        knownFontsMap.put("Lucida Console", "Monospaced");
        knownFontsMap.put("Lucida Sans Typewriter", "Monospaced");
        knownFontsMap.put("Lucida Typewriter", "Monospaced");
        knownFontsMap.put("Monaco", "Monospaced");
        knownFontsMap.put("Monospace", "Monospaced");
        knownFontsMap.put("MS Gothic", "Monospaced");
        knownFontsMap.put("MS Mincho", "Monospaced");
        knownFontsMap.put("OCR-A", "Monospaced");
        knownFontsMap.put("OCR-B", "Monospaced");
        knownFontsMap.put("Orator", "Monospaced");
        knownFontsMap.put("Ormaxx", "Monospaced");
        knownFontsMap.put("Pragmata", "Monospaced");
        knownFontsMap.put("Prestige", "Monospaced");
        knownFontsMap.put("ProFont", "Monospaced");
        knownFontsMap.put("Sydnie", "Monospaced");
        knownFontsMap.put("Terminal", "Monospaced");
    }
}

