/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.officeconnector.index.word;

import com.atlassian.bonnie.search.SearchableAttachment;
import com.atlassian.bonnie.search.extractor.BaseAttachmentContentExtractor;
import com.atlassian.bonnie.search.extractor.ExtractorException;
import com.atlassian.confluence.extra.office.OfficeFile;
import com.atlassian.plugins.conversion.extract.xml.WordXMLExtractor;
import java.io.InputStream;

public class WordXMLTextExtractor
extends BaseAttachmentContentExtractor {
    private static final String[] CONTENT_TYPES = OfficeFile.getMimeTypesFor((OfficeFile.Type)OfficeFile.Type.Word, (OfficeFile.Version)OfficeFile.Version.V2007).toArray(new String[0]);
    private static final String[] EXTENSIONS = OfficeFile.getExtensionsFor((OfficeFile.Type)OfficeFile.Type.Word, (OfficeFile.Version)OfficeFile.Version.V2007).toArray(new String[0]);
    private static final long MAX_XML_SIZE = Long.getLong("officeconnector.textextract.word.docxmaxsize", 0x1000000L);

    protected String[] getMatchingContentTypes() {
        return CONTENT_TYPES;
    }

    protected String[] getMatchingFileExtensions() {
        return EXTENSIONS;
    }

    protected String extractText(InputStream inputStream, SearchableAttachment attachment) throws ExtractorException {
        try {
            return WordXMLExtractor.extractText((InputStream)inputStream, (long)MAX_XML_SIZE);
        }
        catch (Exception e) {
            throw new ExtractorException((Throwable)e);
        }
    }
}

