/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.officeconnector.index.powerpoint;

import com.atlassian.bonnie.search.SearchableAttachment;
import com.atlassian.bonnie.search.extractor.BaseAttachmentContentExtractor;
import com.atlassian.bonnie.search.extractor.ExtractorException;
import com.atlassian.confluence.extra.office.OfficeFile;
import com.atlassian.confluence.extra.officeconnector.index.powerpoint.ExtendedXSLFPowerPointExtractor;
import java.io.InputStream;
import org.apache.poi.openxml4j.opc.OPCPackage;

public class PowerPointXMLTextExtractor
extends BaseAttachmentContentExtractor {
    private static final String[] CONTENT_TYPES = OfficeFile.getMimeTypesFor((OfficeFile.Type)OfficeFile.Type.PowerPoint, (OfficeFile.Version)OfficeFile.Version.V2007).toArray(new String[0]);
    private static final String[] EXTENSIONS = OfficeFile.getExtensionsFor((OfficeFile.Type)OfficeFile.Type.PowerPoint, (OfficeFile.Version)OfficeFile.Version.V2007).toArray(new String[0]);

    protected String extractText(InputStream is, SearchableAttachment attachment) throws ExtractorException {
        try {
            OPCPackage bundle = OPCPackage.open((InputStream)is);
            ExtendedXSLFPowerPointExtractor extractor = new ExtendedXSLFPowerPointExtractor(bundle);
            extractor.setNotesByDefault(true);
            return extractor.getText();
        }
        catch (Exception e) {
            throw new ExtractorException("Error reading content of PowerPoint document: " + e.getMessage(), (Throwable)e);
        }
    }

    protected String[] getMatchingContentTypes() {
        return CONTENT_TYPES;
    }

    protected String[] getMatchingFileExtensions() {
        return EXTENSIONS;
    }
}

