/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SizeLimitedInputStream
extends InputStream {
    private final int maximumLength;
    private final InputStream wrappedInputStream;
    private long currentLength;

    public SizeLimitedInputStream(InputStream wrappedInputStream, int maxBytesToRead) {
        this.wrappedInputStream = new BufferedInputStream(wrappedInputStream);
        this.maximumLength = maxBytesToRead;
    }

    @Override
    public int read() throws IOException {
        if (++this.currentLength > (long)this.maximumLength) {
            throw this.tooMuchData();
        }
        return this.wrappedInputStream.read();
    }

    private IOException tooMuchData() {
        return new IOException("Tried to read past the data limit threshold of " + this.maximumLength + " bytes");
    }

    @Override
    public long skip(long n) throws IOException {
        this.currentLength += n;
        if (this.currentLength > (long)this.maximumLength) {
            throw this.tooMuchData();
        }
        return this.wrappedInputStream.skip(n);
    }

    @Override
    public void close() throws IOException {
        this.wrappedInputStream.close();
    }

    @Override
    public int available() throws IOException {
        return this.wrappedInputStream.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.wrappedInputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrappedInputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.wrappedInputStream.markSupported();
    }
}

