/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record.color;

import com.benryan.pptx.record.color.ColorSpaceType;
import com.benryan.pptx.record.color.FactorAdjustment;
import org.apache.xmlbeans.XmlObject;

public class FactorOffsetAdjustment
extends FactorAdjustment {
    private String name;
    private ColorSpaceType colorSpace;
    private int componentOffsetIndex;

    public FactorOffsetAdjustment(String name, ColorSpaceType colorSpace, int componentOffsetIndex) {
        this.name = name;
        this.colorSpace = colorSpace;
        this.componentOffsetIndex = componentOffsetIndex;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ColorSpaceType requiredColorSpace() {
        return this.colorSpace;
    }

    public int getComponentOffsetIndex() {
        return this.componentOffsetIndex;
    }

    @Override
    public void adjust(float[] colorComponents, XmlObject value) {
        int index = this.getComponentOffsetIndex();
        float factor = this.getFactor(value);
        int n = index;
        colorComponents[n] = colorComponents[n] + factor;
        if (colorComponents[index] > 1.0f) {
            colorComponents[index] = 1.0f;
        } else if (colorComponents[index] < 0.0f) {
            colorComponents[index] = 0.0f;
        }
    }
}

