/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record.color;

import com.benryan.pptx.record.color.Adjustment;
import com.benryan.pptx.record.color.ColorSpaceType;
import org.apache.xmlbeans.XmlObject;

public class ComplementAdjustment
implements Adjustment {
    @Override
    public void adjust(float[] colorComponents, XmlObject value) {
        float doubleMidpoint = this.findMidPoint(colorComponents) * 2.0f;
        colorComponents[0] = doubleMidpoint - colorComponents[0];
        colorComponents[1] = doubleMidpoint - colorComponents[1];
        colorComponents[2] = doubleMidpoint - colorComponents[2];
    }

    private float findMidPoint(float[] colorComponents) {
        float high = 0.0f;
        float low = 1.0f;
        for (float component : colorComponents) {
            if (high < component) {
                high = component;
            }
            if (!(low > component)) continue;
            low = component;
        }
        return (high + low) / 2.0f;
    }

    @Override
    public ColorSpaceType requiredColorSpace() {
        return ColorSpaceType.RedGreenBlue;
    }

    @Override
    public String getName() {
        return "comp";
    }
}

